package com.pcloud.book.group.set;

import com.pcloud.book.group.dto.GroupTopicDTO;
import com.pcloud.common.core.constant.MQTopicProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @描述：
 * @作者：zhuyajie
 * @创建时间：16:26 2019/7/16
 * @版本：1.0
 */
@Component("groupSet")
public class GroupSet {

    private static final Logger LOGGER = LoggerFactory.getLogger(GroupSet.class);

    @Autowired
    private AmqpTemplate amqpTemplate;

    /**
     * 群分类删除topic
     * @param classifyId
     */
    public void sendGroupClassifyDeleteTopic(Long classifyId) {
        LOGGER.info("【社群书】发送群分类删除topic,<START>");
        GroupTopicDTO groupTopicDTO = new GroupTopicDTO();
        groupTopicDTO.setClassifyId(classifyId);
        try {
            amqpTemplate.convertAndSend(MQTopicProducer.EXCHAGE, MQTopicProducer.GROUP_CLASSIFY_DELETE, groupTopicDTO);
        } catch (Exception e) {
            LOGGER.error("【社群书】发送群分类删除topic,<ERROR>", e);
        }
        LOGGER.info("【社群书】发送群分类删除topic,<END>");
    }

}
