package com.pcloud.book.keywords.entity;

import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author lily
 * @date 2019/4/24 11:38
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString(callSuper = true)
public class BookKeyword extends BaseEntity {

    private static final long serialVersionUID = -2202518041150996052L;
    private Long id;

    /**
     * 图书标识
     */
    private Long bookId;

    /**
     * 欢迎语
     */
    private Long channelId;

    /**
     * 社群码标识
     */
    private Long bookGroupId;

    /**
     * 分类标识
     */
    private Long classifyId;

    /**
     * 设置类型
     */
    private Integer setType;

    /**
     * 是否仓库
     */
    private Integer isWarehouse;

    /**
     * 仓库关键词id
     */
    private Long warehouseId;

    /**
     * 排序
     */
    private Integer rank;

    /**
     * 关键词标识
     */
    private Long keywordId;
    /**
     * 创建人
     */
    private Long createUser;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改用户
     */
    private Long updateUser;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 创建类型0-按书创建，1-按群创建
     */
    private Integer isEdit;


}
