package com.pcloud.book.mq.producer.impl;

import com.pcloud.book.book.dto.BookCoverImgUpdateDTO;
import com.pcloud.book.book.dto.BookNameUpdateDTO;
import com.pcloud.book.clock.dto.PushBookClockKeywordDTO;
import com.pcloud.book.group.dto.PushAddUserMessageDTO;
import com.pcloud.book.mq.producer.BookMQProducer;
import com.pcloud.common.core.constant.MQTopicProducer;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component("bookMQProducer")
public class BookProducerImpl implements BookMQProducer {

    @Resource
    private AmqpTemplate amqpTemplate;

    @Override
    public void sendUpdateBookCoverImgTopic(BookCoverImgUpdateDTO bookCoverImgUpdateDTO) {
        amqpTemplate.convertAndSend(MQTopicProducer.EXCHAGE, MQTopicProducer.UPDATE_BOOK_COVERIMG, bookCoverImgUpdateDTO);
    }

    @Override
    public void sendUpdateBookNameTopic(BookNameUpdateDTO bookNameUpdateDTO) {
        amqpTemplate.convertAndSend(MQTopicProducer.EXCHAGE, MQTopicProducer.UPDATE_BOOK_NAME, bookNameUpdateDTO);
    }

    @Override
    public void pushAddUserMessageTopic(PushAddUserMessageDTO pushAddUserMessageDTO) {
        amqpTemplate.convertAndSend(MQTopicProducer.EXCHAGE, MQTopicProducer.PUSH_ADD_USER_MESSAGE, pushAddUserMessageDTO);
    }

    @Override
    public void pushBookClockKeyword(PushBookClockKeywordDTO pushBookClockKeywordDTO) {
        amqpTemplate.convertAndSend(MQTopicProducer.EXCHAGE, MQTopicProducer.PUSH_BOOK_CLOCK_KEYWORD, pushBookClockKeywordDTO);
    }
}
