package com.pcloud.book.push.dao.impl;

import com.pcloud.book.push.dao.PushDao;
import com.pcloud.book.push.entity.Push;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/4/17 17:36
 **/
@Repository("pushDao")
public class PushDaoImpl extends BaseDaoImpl<Push> implements PushDao {
    @Override
    public void deleteByPushId(Long pushId, Long partyId) {
        Map<String,Object> map=new HashMap<>();
        map.put("pushId",pushId);
        map.put("partyId",partyId);
        super.getSqlSession().update(getStatement("deleteByPushId"), map);
    }

    @Override
    public Push getByPushId(Long pushId) {
        return super.getSqlSession().selectOne(getStatement("getByPushId"), pushId);
    }

    @Override
    public void updatePushTime(Push push) {
        super.getSqlSession().update(getStatement("updatePushTime"), push);
    }

    @Override
    public List<Push> getByPushPlanId(Long pushPlanId) {
        return super.getSqlSession().selectList(getStatement("getByPushPlanId"), pushPlanId);
    }

    @Override
    public List<Push> getByPushPlanIds(List<Long> pushPlanIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("pushPlanIds", pushPlanIds);
        return super.getSqlSession().selectList(getStatement("getByPushPlanIds"), map);
    }

    @Override
    public List<Push> getPlanPushListPartyId(Long partyId) {
        return super.getSqlSession().selectList(getStatement("getPlanPushListPartyId"), partyId);
    }

}
