package com.pcloud.common.core.biz.impl;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.biz.UpdateSuperSearchQueueBiz;
import com.pcloud.common.core.constant.MQTopicProducer;
import com.pcloud.common.core.dto.UpdateSuperSearchMQDTO;
import com.pcloud.common.exceptions.BizException;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateSuperSearchQueueBizImpl implements UpdateSuperSearchQueueBiz {

    @Autowired
    private AmqpTemplate amqpTemplate;

    @Override
    @ParamLog("超级搜索更新queue")
    public void sendMessageQueue(UpdateSuperSearchMQDTO superSearchMQDTO) throws BizException {
        amqpTemplate.convertAndSend(MQTopicProducer.EXCHAGE, MQTopicProducer.UPDATE_SUPER_SEARCH, superSearchMQDTO);
    }
}
