package com.pcloud.common.config;

import com.alibaba.nacos.api.annotation.NacosInjected;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import org.springframework.stereotype.Component;

@Component
public class NacosConfigServiceInstance {

    private static ConfigService SERVICE;

    @NacosInjected
    public void setConfigService(ConfigService configService) throws NacosException {
        if (SERVICE == null) {
            SERVICE = configService;
        }
        PublicConfig.loadPublicSystem(configService);
    }

    public static ConfigService getInstance() {
        return SERVICE;
    }
}
