package com.pcloud.common.utils.aliyun;


import com.huawei.mpc.client.MpcClient;
import com.huawei.mpc.client.MpcConfig;
import com.huawei.mpc.model.ObsObjInfo;
import com.huawei.mpc.model.thumbnail.CreateThumbnailRequest;
import com.huawei.mpc.model.thumbnail.CreateThumbnailResponse;
import com.huawei.mpc.model.thumbnail.QueryThumbTaskRequest;
import com.huawei.mpc.model.thumbnail.QueryThumbTaskResponse;
import com.huawei.mpc.model.transcoding.CreateTranscodingRequest;
import com.huawei.mpc.model.transcoding.CreateTranscodingResponse;
import com.huawei.mpc.model.transcoding.QueryTranscodingRequest;
import com.huawei.mpc.model.transcoding.QueryTranscodingResponse;
import com.huawei.mpc.model.transcoding.TextWatermark;
import com.obs.services.ObsClient;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.DownloadFileRequest;
import com.obs.services.model.DownloadFileResult;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.obs.services.model.TemporarySignatureRequest;
import com.obs.services.model.TemporarySignatureResponse;
import com.obs.services.model.UploadFileRequest;
import com.pcloud.common.constant.AliyunConstant;
import com.pcloud.common.constant.FilePathConstant;
import com.pcloud.common.constant.UrlConstant;
import com.pcloud.common.dto.OssImageCropDTO;
import com.pcloud.common.dto.OssImageDTO;
import com.pcloud.common.dto.OssMediaInfoDTO;
import com.pcloud.common.entity.OSSFileDO;
import com.pcloud.common.entity.UploadResultInfo;
import com.pcloud.common.enums.AliyunEnum;
import com.pcloud.common.enums.ImageTypeEnum;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.exceptions.FileException;
import com.pcloud.common.utils.DateUtils;
import com.pcloud.common.utils.FileUtils;
import com.pcloud.common.utils.ImageUtils;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.LocalDateUtils;
import com.pcloud.common.utils.UUIDUitl;
import com.pcloud.common.utils.encode.ZSEncode;
import com.pcloud.common.utils.httpclient.UrlUtils;
import com.pcloud.common.utils.rsa.MD5;
import com.pcloud.common.utils.string.StringTools;
import com.pcloud.common.utils.string.StringUtil;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.hutool.core.codec.Base64;
import lombok.SneakyThrows;

/**
 * @描述：
 * @作者：zyj
 * @创建时间：2020年6月2日
 */
public class OssUtils {

    /**
     * logger
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(OssUtils.class);

    /**
     * ACS客户端，华东地区
     */
    private static MpcClient acsClient;

    /**
     * ACS客户端，华北地区
     */
    private static MpcClient acsClientBj;

    /**
     * 获取ACS客户端
     */
    private static MpcClient initAcsClient(String bucketName) {
        try {
            MpcConfig mpcConfig = new MpcConfig();
            mpcConfig.setEndPoint(AliyunConstant.getMtsEndPoint(bucketName));// 设置转码节点地址
            mpcConfig.setProjectId(AliyunConstant.PROJECT_ID);// 设置用户项目编号ProjectId
            mpcConfig.setSk(AliyunConstant.MtsSK);// 设置sk
            mpcConfig.setAk(AliyunConstant.MtsAK);// 设置ak
            MpcClient mpcClient = new MpcClient(mpcConfig);
            return mpcClient;
        } catch (Exception e) {
            LOGGER.error("【aliOSS】初始化媒体转码ACS客户端失败:" + e.getMessage(), e);
            throw new FileException(FileException.FILE_READ_FAILURE, "初始化Acs客户端失败");
        }
    }


    /**
     * 获取ACS客户端
     */
    private static MpcClient getAcsClient(String bucketName) {
        if (AliyunConstant.LIVE_BUCKET.equals(bucketName)) {
            if (acsClientBj == null) {
                acsClientBj = initAcsClient(bucketName);
            }
            return acsClientBj;
        } else {
            if (acsClient == null) {
                acsClient = initAcsClient(bucketName);
            }
            return acsClient;
        }
    }

    /**
     * 本地上传文件到aliOSS,isFlag=true，表示上传成功
     *
     * @param filePath 源文件物理地址
     * @param fileName 源文件名称，可为null
     */
    public static UploadResultInfo uploadLocalFile(String filePath, String fileName) throws FileException {
        return uploadLocalFile4CustomName(filePath, null);
    }

    /**
     * 本地上传文件到aliOSS,isFlag=true，表示上传成功 <br> 自定义上传后的文件名称
     *
     * @param filePath 源文件物理地址
     * @param fileName 源文件名称，可为null
     */
    public static UploadResultInfo uploadLocalFile4CustomName(String filePath, String fileName) throws FileException {
        String fileType = FileUtils.getFileType(filePath);
        String outObjectKey = getOutObjectKey(AliyunEnum.UPLOAD, fileName, fileType);
        uploadPointFile2OSS(filePath, AliyunConstant.FILE_BUCKET, outObjectKey);
        UploadResultInfo uploadResultInfo = getResultInfo(outObjectKey, new File(filePath).length(), null,
                AliyunConstant.FILE_BUCKET);
        // 如果上传的是图片转换成webp
//		if (uploadResultInfo != null && FileTypeUtils.equalsGatherName(fileType, FileTypeUtils.IMAGE)) {
//			ImageUtils.toWebp(uploadResultInfo.getUrl());
//		}
        return uploadResultInfo;
    }

    /**
     * 父子文件上传，子文件全路径和父文件相同，文件后缀类型自定义
     *
     * @param filePath      子文件本地路径
     * @param parentFileUrl 仅限OSS的全路径，其他本地文件路径均不支持
     */
    public static UploadResultInfo uploadLocalFile4Child(String filePath, String parentFileUrl) throws FileException {
        String fileType = FileUtils.getFileType(filePath);
        String outObjectKey = splitObjectKey(parentFileUrl) + "." + fileType;
        uploadPointFile2OSS(filePath, AliyunConstant.FILE_BUCKET, outObjectKey);
        return getResultInfo(outObjectKey, new File(filePath).length(), null, AliyunConstant.FILE_BUCKET);
    }

    /**
     * byte[]数组文件流上传 ,isFlag=true，表示上传成功
     *
     * @param buff     源文件字节数组
     * @param fileName 源文件名称不带后缀，可为null
     * @param fileType 源文件后缀
     */
    public static UploadResultInfo uploadFileByte(byte[] buff, String fileName, String fileType) throws FileException {
        return uploadFileStream(new ByteArrayInputStream(buff), fileName, fileType);
    }

    /**
     * 文件流上传到aliOSS, isFlag=true，表示上传成功 <br/> 慎用，该方法稳定性不确定，曾出现过上传的文件流丢失的情况
     *
     * @param is       源文件流
     * @param fileName 源文件名称不带后缀，可为null
     * @param fileType 源文件后缀
     */
    public static UploadResultInfo uploadFileStream(InputStream is, String fileName, String fileType)
            throws FileException {
        String outObjectKey = getOutObjectKey(AliyunEnum.UPLOAD, null, fileType);
        uploadFileStream2OSS(is, AliyunConstant.FILE_BUCKET, outObjectKey);
        UploadResultInfo uploadResultInfo = getResultInfo(outObjectKey, null, null, AliyunConstant.FILE_BUCKET);
        // 如果上传的是图片转换成webp
//		if (uploadResultInfo != null && FileTypeUtils.equalsGatherName(fileType, FileTypeUtils.IMAGE)) {
//			ImageUtils.toWebp(uploadResultInfo.getUrl());
//		}
        return uploadResultInfo;
    }

    /**
     * 文件流上传到aliOSS
     */
    @SneakyThrows
    private static OSSFileDO uploadFileStream2OSS(InputStream is, String bucketName, String objectKey) {
        if (is == null) {
            throw new FileException(FileException.FILE_CONTENT_NOT_EXIST, "InputStream is null!");
        }
        ObsClient client = getOSSClient(bucketName);
        OSSFileDO ossFileDO = null;
        try {
            client.putObject(bucketName, objectKey, is);
            ossFileDO = new OSSFileDO(AliyunConstant.getOssRegion(bucketName), bucketName,
                    URLEncoder.encode(objectKey, "utf-8"));
            is.close();
        } catch (Exception e) {
            LOGGER.error("【aliOSS】上传文件失败:" + e.getMessage(), e);
            throw new FileException(FileException.FILE_UPLOAD_FAILURE, "上传文件失败");
        } finally {
//            client.close();
        }
        //oss%2Ftranscode%2Faudio%2Fmp3%2Ftest_20200529150529182.mp3
        if (!StringUtil.isEmpty(ossFileDO.getObject()) && ossFileDO.getObject().contains("%2F")) {
            ossFileDO.setObject(ossFileDO.getObject().replace("%2F", "/"));
        }
        return ossFileDO;
    }

    /**
     * 断点续传上传文件到aliOSS
     */
    @SneakyThrows
    private static OSSFileDO uploadPointFile2OSS(String filePath, String bucketName, String objectKey)
            throws FileException {
        if (filePath == null) {
            throw new RuntimeException("filePath is null!");
        }
        ObsClient ossClient = getOSSClient(bucketName);
        OSSFileDO ossFileDO = null;
        try {
            // 设置断点续传请求
            UploadFileRequest uploadFileRequest = new UploadFileRequest(bucketName, objectKey);
            // 指定上传的本地文件
            uploadFileRequest.setUploadFile(filePath);
            // 指定上传并发线程数
            uploadFileRequest.setTaskNum(5);
            // 指定上传的分片大小
            uploadFileRequest.setPartSize(5 * 1024 * 1024);
            // 开启断点续传
            uploadFileRequest.setEnableCheckpoint(true);
            // 断点续传上传
            ossClient.uploadFile(uploadFileRequest);
            ossFileDO = new OSSFileDO(AliyunConstant.getOssRegion(bucketName), bucketName,
                    URLEncoder.encode(objectKey, "utf-8"));
        } catch (Throwable e) {
            LOGGER.error("【aliOSS】上传文件失败:" + e.getMessage(), e);
            throw new FileException(FileException.FILE_UPLOAD_FAILURE, "上传文件失败");
        } finally {
//            ossClient.close();
        }
        //oss%2Ftranscode%2Faudio%2Fmp3%2Ftest_20200529150529182.mp3
        if (!StringUtil.isEmpty(ossFileDO.getObject()) && ossFileDO.getObject().contains("%2F")) {
            ossFileDO.setObject(ossFileDO.getObject().replace("%2F", "/"));
        }
        return ossFileDO;
    }

    /**
     * 断点续传上传文件到aliOSS
     */
    @SneakyThrows
    private static DownloadFileResult downloadPointFile2OSS(String filePath, String outFilePath, String bucketName, String objectKey)
            throws FileException {
        if (filePath == null) {
            throw new RuntimeException("filePath is null!");
        }
        ObsClient ossClient = getOSSClient(bucketName);
        DownloadFileResult result = null;
        try {
            // 创建ObsClient实例
            ObsClient obsClient = getOSSClient(bucketName);
            DownloadFileRequest request = new DownloadFileRequest(bucketName, objectKey);
            // 设置下载对象的本地文件路径
            request.setDownloadFile(outFilePath);
            // 设置分段下载时的最大并发数
            request.setTaskNum(5);
            // 设置分段大小为10MB
            request.setPartSize(10 * 1024 * 1024);
            // 开启断点续传模式
            request.setEnableCheckpoint(true);
            // 进行断点续传下载
            result = obsClient.downloadFile(request);
        } catch (Throwable e) {
            LOGGER.error("【aliOSS】下载文件失败:" + e.getMessage(), e);
            throw new FileException(FileException.FILE_UPLOAD_FAILURE, "上传文件失败");
        } finally {
//            ossClient.close();
        }
        return result;
    }

    /**
     * 提交MP4转码作业 new
     *
     * @param fileName 源文件的名称不带后缀,可为null
     * @param filePath 源文件本地路径
     */
    public static String submitTranscodeJobMp4(String fileName, String filePath) throws FileException {
        String[] result = submitTranscodeJobMp4Ex(fileName, filePath);
        return result[0];
    }

    /**
     * 提交MP4转码作业 new
     *
     * @return [0]:jobId,转码作业ID;[1]:转码后的地址
     */
    public static String[] submitTranscodeJobMp4Ex(String fileName, String filePath) throws FileException {
        LOGGER.info("【aliOSS】提交MP4转码作业.[filePath]=" + filePath);
        String fileType = FileUtils.getFileType(filePath);
        String inObjectKey = getInObjectKey(AliyunEnum.TRANSCODE, fileName, fileType);
        String inputBucketName = AliyunConstant.INPUT_BUCKET;
        OSSFileDO ossFileDO = uploadPointFile2OSS(filePath, inputBucketName, inObjectKey);
        String outObjectKey = getTranscodeOutObjectKey(AliyunEnum.TRANSCODE, "mp4");
        return transcodeJob(ossFileDO, AliyunConstant.getMp4TemplateId(inputBucketName), outObjectKey, null, null);
    }

    /**
     * 提交MP4转码作业,文件流方式 new
     *
     * @param buff     源文件流
     * @param fileName 源文件的名称不带后缀,可为null
     * @param fileType 源文件的后缀
     */
    public static String submitTranscodeJobMp4(byte[] buff, String fileName, String fileType) throws FileException {
        LOGGER.info("【aliOSS】提交MP4转码作业.");
        String inObjectKey = getInObjectKey(AliyunEnum.TRANSCODE, fileName, fileType);
        String inputBucketName = AliyunConstant.INPUT_BUCKET;
        OSSFileDO inputFile = uploadFileStream2OSS(new ByteArrayInputStream(buff), inputBucketName, inObjectKey);
        String outObjectKey = getTranscodeOutObjectKey(AliyunEnum.TRANSCODE, "mp4");
        String[] result = transcodeJob(inputFile, AliyunConstant.getMp4TemplateId(inputBucketName), outObjectKey, null,
                null);
        return result[0];
    }

    /**
     * 提交MP3转码作业 new
     *
     * @param fileName 源文件的名称不带后缀,可为null
     * @param filePath 源文件本地路径
     */
    public static String submitTranscodeJobMp3(String fileName, String filePath) throws FileException {
        String[] result = submitTranscodeJobMp3Ex(fileName, filePath);
        return result[0];
    }

    /**
     * 提交MP3转码作业 new
     *
     * @return [0]:jobId,转码作业ID;[1]:转码后的地址
     */
    public static String[] submitTranscodeJobMp3Ex(String fileName, String filePath) throws FileException {
        LOGGER.info("【aliOSS】提交MP3转码作业.[filePath]=" + filePath);
        String fileType = FileUtils.getFileType(filePath);
        String inObjectKey = getInObjectKey(AliyunEnum.TRANSCODE, fileName, fileType);
        String inputBucketName = AliyunConstant.INPUT_BUCKET;
        OSSFileDO ossFileDO = uploadPointFile2OSS(filePath, AliyunConstant.INPUT_BUCKET, inObjectKey);
        String outObjectKey = getTranscodeOutObjectKey(AliyunEnum.TRANSCODE, "mp3");
        return transcodeJob(ossFileDO, AliyunConstant.getMp3TemplateId(inputBucketName), outObjectKey, null, null);
    }

    /**
     * 提交MP3转码作业，文件流方式 <br/> 使用byte[]方式上传，文件流上传容易导致读取长度0，造成转码失败 new
     *
     * @param is       源文件流
     * @param fileName 源文件的名称不带后缀,可为null
     * @param fileType 源文件的后缀
     */
    @Deprecated
    public static String submitTranscodeJobMp3(InputStream is, String fileName, String fileType) throws FileException {
        String inObjectKey = getInObjectKey(AliyunEnum.TRANSCODE, fileName, fileType);
        String inputBucketName = AliyunConstant.INPUT_BUCKET;
        OSSFileDO inputFile = uploadFileStream2OSS(is, inputBucketName, inObjectKey);
        String outObjectKey = getTranscodeOutObjectKey(AliyunEnum.TRANSCODE, "mp3");
        String[] result = transcodeJob(inputFile, AliyunConstant.getMp3TemplateId(inputBucketName), outObjectKey, null,
                null);
        return result[0];
    }

    /**
     * 提交MP3转码作业 new
     *
     * @param buff     文件
     * @param fileName 源文件的名称不带后缀,可为null
     * @param fileType 上传的文件后缀
     */
    public static String submitTranscodeJobMp3(byte[] buff, String fileName, String fileType) throws FileException {
        LOGGER.info("【aliOSS】提交MP3转码作业.");
        String inObjectKey = getInObjectKey(AliyunEnum.TRANSCODE, fileName, fileType);
        String inputBucketName = AliyunConstant.INPUT_BUCKET;
        OSSFileDO inputFile = uploadFileStream2OSS(new ByteArrayInputStream(buff), inputBucketName, inObjectKey);
        String outObjectKey = getTranscodeOutObjectKey(AliyunEnum.TRANSCODE, "mp3");
        String[] result = transcodeJob(inputFile, AliyunConstant.getMp3TemplateId(inputBucketName), outObjectKey, null,
                null);
        return result[0];
    }

    /**
     * 转码作业，同步的方式 new
     */
    public static UploadResultInfo submitTranscodeJobSync(String fileUrl) throws FileException {
        String bucketName = AliyunConstant.getBucketName(fileUrl);
        String jobId = transcodeJob(null, fileUrl);
        return transcodeJobResultSync(jobId, bucketName);
    }

    /**
     * 转码作业 new
     *
     * @param fileName 文件名称
     * @param filePath 文件地址
     */
    public static String transcodeJob(String fileName, String filePath) throws FileException {
        String[] result = transcodeJobEx(fileName, filePath, null, null);
        return result[0];
    }

    /**
     * 转码作业 new
     *
     * @param fileUrl          文件地址
     * @param outFileType      输出文件类型
     * @param waterMarkContent 视频水印文本,如果不需要水印传null
     * @return [0]:jobId,[1]:转码后的地址
     */
    public static String[] transcodeJobEx(String fileName, String fileUrl, String outFileType,
                                          String waterMarkContent) {
        String fileType = FileUtils.getFileType(fileUrl);
        if (StringTools.contains(fileUrl, AliyunConstant.OSS_CDN_URLS)) {
            return transcodeJobExistOSS(fileUrl, fileName, fileType, outFileType, waterMarkContent);
        } else {
            return transcodeJobNotExistOSS(fileUrl, fileName, fileType);
        }
    }

    /**
     * 已经存在于OSS中的文件转码 new
     */
    private static String[] transcodeJobExistOSS(String fileUrl, String fileName, String fileType, String outFileType,
                                                 String waterMarkContent) {
        LOGGER.info("【aliOSS】已经存在于OSS中的文件转码.<START>.[fileUrl]=" + fileUrl + ",[outFileType]=" + outFileType);
        String[] result = null;
        String inObjectKey = splitObjectKey(fileUrl);
        String inputBucketName = getInputBucketName(fileUrl);
        OSSFileDO ossFileDO = new OSSFileDO(AliyunConstant.getOssRegion(inputBucketName), inputBucketName, inObjectKey);
        if (FileUtils.VIDEO.equals(FileUtils.getGatherName(fileType))) {
            outFileType = StringUtil.isEmpty(outFileType) ? "mp4" : outFileType;
            String outObjectKey = getTranscodeOutObjectKey(AliyunEnum.TRANSCODE, outFileType);
            // 组装水印参数
            CreateTranscodingRequest.Watermark[] waterMarkConfigArray = getWaterMarkConfig(waterMarkContent);
            result = transcodeJob(ossFileDO, AliyunConstant.getVideoTemplateId(inputBucketName, outFileType),
                    outObjectKey, waterMarkConfigArray, null);
        } else if (FileUtils.AUDIO.equals(FileUtils.getGatherName(fileType))) {
            String outObjectKey = getTranscodeOutObjectKey(AliyunEnum.TRANSCODE, "mp3");
            result = transcodeJob(ossFileDO, AliyunConstant.getMp3TemplateId(inputBucketName), outObjectKey, null,
                    null);
        }
        return result;
    }

    /**
     * 不存在于OSS中的文件转码，要先上传 new
     */
    private static String[] transcodeJobNotExistOSS(String fileUrl, String fileName, String fileType) {
        LOGGER.info("【aliOSS】不存在于OSS中的文件转码.<START>.[fileUrl]=" + fileUrl);
        if (FileUtils.VIDEO.equals(FileUtils.getGatherName(fileType))) {
            return submitTranscodeJobMp4Ex(fileName, fileUrl);
        } else if (FileUtils.AUDIO.equals(FileUtils.getGatherName(fileType))) {
            return submitTranscodeJobMp3Ex(fileName, fileUrl);
        }
        return null;
    }

    /**
     * 获取文件所在的BUCKET名称
     */
    private static String getInputBucketName(String fileUrl) {
        String inputBucketName = AliyunConstant.getBucketName(fileUrl);
        if (AliyunConstant.FILE_BUCKET.equals(inputBucketName)) {
            inputBucketName = fileUrlExist001(fileUrl) ? AliyunConstant.INPUT_BUCKET : inputBucketName;
        }
        return inputBucketName;
    }

    /**
     * 文件合并,异步方法
     *
     * @param fileUrl   主文件地址
     * @param mergeUrls 需要合并的子文件列表,最多支持4个
     * @return
     * @throws FileException
     */
   /* public static String submitMergeJob(String fileUrl, List<String> mergeUrls) throws FileException {
        LOGGER.info("【aliOSS】提交合并作业.<START>.[fileUrl]=" + fileUrl + ",[mergeUrls]=" + mergeUrls);
        String fileType = FileUtils.getFileType(fileUrl);
        if (ListUtils.isEmpty(mergeUrls)) {
            throw new FileException(FileException.FILE_TYPE_ERROR, "不是有效的音视频文件");
        }
        OSSFileDO ossFileDO = null;
        String inputBucketName = null;
        if (StringTools.contains(fileUrl, AliyunConstant.OSS_CDN_URLS)) {
            String inObjectKey = splitObjectKey(fileUrl);
            inputBucketName = AliyunConstant.getBucketName(fileUrl);
            ossFileDO = new OSSFileDO(AliyunConstant.getOssRegion(inputBucketName), inputBucketName, inObjectKey);
        } else {
            inputBucketName = AliyunConstant.FILE_BUCKET;
            String inObjectKey = getInObjectKey(AliyunEnum.MERGE, null, fileType);
            ossFileDO = uploadPointFile2OSS(fileUrl, inputBucketName, inObjectKey);
        }
        String outObjectKey = getOutObjectKey(AliyunEnum.MERGE, null, fileType);
        String templateId = "mp3".equals(fileType) ? AliyunConstant.getMp3TemplateId(inputBucketName)
                : AliyunConstant.getMp4TemplateId(inputBucketName);
        String[] result = transcodeJob(ossFileDO, templateId, outObjectKey, null, mergeUrls);
        LOGGER.info("【aliOSS】提交合并作业.<END>.[result]=" + JSON.toJSONString(result));
        return result[0];
    }*/

    /**
     * 视频文件合并,同步方法
     *
     * @param fileUrl   主文件地址
     * @param mergeUrls 需要合并的子文件列表,最多支持4个
     * @return
     * @throws FileException
     */
   /* public static UploadResultInfo submitMergeJobMp4Sync(String fileUrl, List<String> mergeUrls) throws FileException {
        String bucketName = AliyunConstant.getBucketName(fileUrl);
        String jobId = submitMergeJob(fileUrl, mergeUrls);
        return transcodeJobResultSync(jobId, bucketName);
    }*/

    /**
     * 视频文件合并,同步方法
     *
     * @param fileUrl   主文件地址
     * @param mergeUrls 需要合并的子文件列表,最多支持4个
     * @return
     * @throws FileException
     */
   /* public static UploadResultInfo submitMergeJobSync(String fileUrl, List<String> mergeUrls) throws FileException {
        String bucketName = AliyunConstant.getBucketName(fileUrl);
        String jobId = submitMergeJob(fileUrl, mergeUrls);
        return transcodeJobResultSync(jobId, bucketName);
    }*/

    /**
     * 同步的方式获取转码后的结果 new
     */
    private static UploadResultInfo transcodeJobResultSync(String jobId, String bucketName) throws FileException {
        LOGGER.info("【aliOSS】同步获取转码后的结果.<START>.[jobId]=" + jobId + ",[bucketName]=" + bucketName);
        int total = 0;
        while (true) {
            // 如果超过2小时,认定转换失败
            if (total > 2 * 60 * 60) {
                return null;
            }
            UploadResultInfo uploadResultInfo = OssUtils.getOSSResult(jobId, bucketName);
            if (uploadResultInfo != null) {
                return uploadResultInfo;
            }
            try {
                Thread.sleep(3 * 1000);
            } catch (Exception e) {
                LOGGER.error("【文件转码】 合并视频线程进入休眠状态失败: " + e.getMessage(), e);
                throw new FileException(FileException.FILE_CONVERT_FAIL, "视频文件合并失败");
            }
            total += 3;
        }
    }

    /**
     * 转码作业 * @param null
     */
    private static String[] transcodeJob(OSSFileDO inputFile, String templateId, String outObjectKey, CreateTranscodingRequest.Watermark[] watermarkArray, List<String> mergeUrls) {
        // 媒体处理服务构造方法
        MpcClient mpcClient = getAcsClient(inputFile.getBucket());

        //设置媒体处理服务请求参数
        CreateTranscodingRequest createTranscodingRequest = new CreateTranscodingRequest();

        //设置转码的输入文件路径参数，可通过华为云OBS对象存储服务控制台查看。
        ObsObjInfo input = new ObsObjInfo();
        //设置输入桶名
        input.setBucket(inputFile.getBucket());
        //设置源文件路径
        input.setObject(inputFile.getObject());
        //设置输入桶所在区域
        input.setLocation(inputFile.getLocation());
        createTranscodingRequest.setInput(input);

        // 设置转码的输出文件路径参数，可通过华为云OBS对象存储服务控制台查看。
        ObsObjInfo output = new ObsObjInfo();
        //设置输出桶名
        output.setBucket(AliyunConstant.getOutBucket(input.getBucket()));
        //设置输出文件路径
        output.setObject(outObjectKey);
        //设置输出桶所在区域
        output.setLocation(inputFile.getLocation());
        createTranscodingRequest.setOutput(output);

        //设置转码模板ID
        List<Long> transTempIds = new ArrayList<Long>();
        transTempIds.add(Long.valueOf(templateId));
        createTranscodingRequest.setTransTemplateId(transTempIds);

        //文字水印
        createTranscodingRequest.setWatermarks(watermarkArray);

        String[] result = new String[2];
        try {
            //发送媒体处理服务请求
            CreateTranscodingResponse createTranscodingResponse = mpcClient.createTranscodingTask(createTranscodingRequest);
            //返回消息
            result[0] = createTranscodingResponse.getTaskId();
            result[1] = getOSSUrl(URLDecoder.decode(outObjectKey, "utf-8"), output.getBucket());
        } catch (Exception e) {
            LOGGER.error("【aliOSS】【ignoreLog】转码作业失败:" + e.getMessage(), e);
            throw new FileException(FileException.FILE_CONVERT_FAIL, "转码作业失败");
        }
        return result;
    }
    /**
     * 转码作业
     *
     * @param inputFile            输入文件
     * @param templateId           转码模板
     * @param outObjectKey         转码输出对象地址
     * @param waterMarkConfigArray 水印参数
     * @return
     * @throws FileException
     */
  /*  private static String[] transcodeJob(OSSFileDO inputFile, String templateId, String outObjectKey,
            JSONArray waterMarkConfigArray, List<String> mergeUrls) throws FileException {
        try {
            outObjectKey = URLEncoder.encode(outObjectKey, "utf-8");
        } catch (UnsupportedEncodingException e) {
            LOGGER.error("【aliOSS】submitTranscodeJob URL encode failed:" + e.getMessage(), e);
            throw new FileException(FileException.FILE_CONVERT_FAIL, "submitTranscodeJob URL encode failed");
        }
        String inputBucketName = inputFile.getBucket();
        String outputBucketName = AliyunConstant.getOutBucket(inputBucketName);
        // 组装转码参数
        JSONObject jobConfig = new JSONObject();
        jobConfig.put("OutputObject", outObjectKey.replace(".m3u8", ""));
        jobConfig.put("TemplateId", templateId);
        // 添加水印
        if (waterMarkConfigArray != null) {
            jobConfig.put("WaterMarks", waterMarkConfigArray);
        }
        // 合并多个视频文件
        JSONArray mergeJson = generateMergeInput(mergeUrls, inputBucketName);
        if (!ListUtils.isEmpty(mergeJson)) {
            jobConfig.put("MergeList", mergeJson.toJSONString());
        }
        JSONArray jobConfigArray = new JSONArray();
        jobConfigArray.add(jobConfig);
        SubmitJobsRequest request = new SubmitJobsRequest();
        request.setInput(inputFile.toJsonString());
        request.setOutputBucket(outputBucketName);
        request.setOutputs(jobConfigArray.toJSONString());
        request.setPipelineId(AliyunConstant.getPipelineId(inputBucketName));
        request.setOutputLocation(AliyunConstant.getOssRegion(inputBucketName));
        Integer outputJobCount = 1;
        SubmitJobsResponse response = null;
        String[] result = new String[2];
        try {
            response = getAcsClient(inputBucketName).getAcsResponse(request);
            if (response.getJobResultList().size() != outputJobCount) {
                throw new RuntimeException("SubmitJobsRequest Size failed");
            }
            SubmitJobsResponse.JobResult.Job job = response.getJobResultList().get(0)
                    .getJob();
            result[0] = job.getJobId();
            result[1] = getOSSUrl(URLDecoder.decode(outObjectKey, "utf-8"), outputBucketName);
        } catch (Exception e) {
            LOGGER.error("【aliOSS】【ignoreLog】转码作业失败:" + e.getMessage(), e);
            throw new FileException(FileException.FILE_CONVERT_FAIL, "转码作业失败");
        }
        return result;
    }*/

    /**
     * 组装视频合并参数
     *
     * @param mergeUrls
     * @param bucketName
     * @return
     */
    /*private static JSONArray generateMergeInput(List<String> mergeUrls, String bucketName) {
        if (ListUtils.isEmpty(mergeUrls)) {
            return null;
        }
        JSONObject mergeInput = new JSONObject();
        JSONArray mergeJsons = new JSONArray();
        for (String mergeUrl : mergeUrls) {
            // 如果是本地文件先上传
            if (!StringTools.startsWith(mergeUrl, new String[]{"http://", "https://"})) {
                UploadResultInfo uploadResultInfo = uploadLocalFile(mergeUrl, null);
                if (!uploadResultInfo.isFlag()) {
                    continue;
                }
                // 替换路径为上传后的文件路径
                mergeUrl = uploadResultInfo.getUrl();
            }
            // 地址域名转换
            String ossOriginalUrl = AliyunConstant.getOSSOriginalUrl(bucketName);
            mergeUrl = StringTools.replace(mergeUrl, AliyunConstant.OSS_CDN_URLS, ossOriginalUrl);
            JSONObject mergeUrlJson = new JSONObject();
            mergeUrlJson.put("MergeURL", mergeUrl);
            mergeJsons.add(mergeUrlJson);
        }
        mergeInput.put("MergeList", mergeJsons);
        return mergeJsons;
    }
*/

    /**
     * 组装视频水印参数
     */
   /* private static JSONArray getWaterMarkConfig(String content) {
        if (StringUtil.isEmpty(content)) {
            return null;
        }
        JSONObject waterMarkConfig = new JSONObject();
        waterMarkConfig.put("Type", "Text");
        // 组装水印文本
        JSONObject waterMarkText = new JSONObject();
        waterMarkText.put("content", new String(Base64.encode(content.getBytes())));
        waterMarkText.put("FontSize", 16);
        waterMarkText.put("Top", 2000);
        waterMarkText.put("Left", 20);
        waterMarkConfig.put("TextWaterMark", waterMarkText);
        JSONArray waterMarkConfigArray = new JSONArray();
        waterMarkConfigArray.add(waterMarkConfig);
        return waterMarkConfigArray;
    }*/
    private static CreateTranscodingRequest.Watermark[] getWaterMarkConfig(String content) {
        if (StringUtil.isEmpty(content)) {
            return null;
        }
        CreateTranscodingRequest.Watermark watermark = new CreateTranscodingRequest.Watermark();
        // 文字水印内容，内容需做Base64编码,
        // 示例：若想添加文字水印“测试文字水印”，那么Content的值为：5rWL6K+V5paH5a2X5rC05Y2w
        watermark.setTextContext(new String(Base64.encode(content.getBytes())));
        TextWatermark textWatermark = new TextWatermark();
        // 字体颜色。
        // 目前颜色支持black,blue,white,green,red,yellow,brown,gold,pink,orange,purple。
        // 默认颜色是white
        textWatermark.setFontColor("black");
        // 字体，当前支持fzyouh、msyh
        // 默认字体是msyh
        textWatermark.setFontName("fzyouh");
        // 字体大小。默认值：16，范围：(4, 120)
        textWatermark.setFontSize(16);
        watermark.setTextWatermark(textWatermark);
        List<CreateTranscodingRequest.Watermark> watermarks = new ArrayList<CreateTranscodingRequest.Watermark>();
        watermarks.add(watermark);
        CreateTranscodingRequest.Watermark[] watermarkArray = new CreateTranscodingRequest.Watermark[watermarks.size()];
        return watermarks.toArray(watermarkArray);
    }

    /**
     * 提交视频剪切作业
     *
     * @param fileName
     * @param fileUrl
     * @param seek     开始时间：［0.000,86399.999］
     * @param duration 持续时长 ［0.000,86399.999］
     * @return
     * @throws FileException
     */
   /*public static String submitClipJob(String fileName, String fileUrl, String seek, String duration)
            throws FileException {
        LOGGER.info("【aliOSS】提交音视频剪切作业.<START>.[fileUrl]=" + fileUrl + ",[seek]=" + seek + ",[duration]=" + duration);
        if (StringUtil.isEmpty(duration)) {
            return null;
        }
        String fileType = FileUtils.getFileType(fileUrl);
        String gatherName = FileUtils.getGatherName(fileType);
        if (!(FileUtils.VIDEO.equals(gatherName) || FileUtils.AUDIO.equals(gatherName))) {
            return null;
        }
        String resultFileUrl = "";
        String outFileType = FileUtils.VIDEO.equals(gatherName) ? "mp4" : "mp3";
        *//*if (StringTools.contains(fileUrl, AliyunConstant.OSS_CDN_URLS)) {
            String inObjectKey = splitObjectKey(fileUrl);
            String inBucketName = fileUrlExist001(fileUrl) ? AliyunConstant.INPUT_BUCKET
                    : AliyunConstant.getBucketName(fileUrl);
            OSSFileDO ossFileDO = new OSSFileDO(AliyunConstant.getOssRegion(inBucketName), inBucketName, inObjectKey);
            String outObjectKey = getOutObjectKey(AliyunEnum.CUT, fileName, outFileType);
            resultFileUrl = clipJob(ossFileDO, outObjectKey, seek, duration);
        } else {
            String inObjectKey = getInObjectKey(AliyunEnum.CUT, fileName, fileType);
            OSSFileDO ossFileDO = uploadPointFile2OSS(fileUrl, AliyunConstant.FILE_BUCKET, inObjectKey);
            String outObjectKey = getOutObjectKey(AliyunEnum.CUT, fileName, outFileType);
            resultFileUrl = clipJob(ossFileDO, outObjectKey, seek, duration);
        }*//*
        LOGGER.info("【aliOSS】提交音视频剪切作业.<END>.[resultFileUrl]=" + resultFileUrl);
        return resultFileUrl;
    }*/

    /**
     * 提交视频剪切作业
     *
     * @param buff
     * @param fileName
     * @param fileType
     * @param seek     开始时间：［0.000,86399.999］
     * @param duration 持续时长 ［0.000,86399.999］
     * @return
     * @throws FileException
     */
    /*public static String submitClipJob(byte[] buff, String fileName, String fileType, String seek, String duration)
            throws FileException {
        LOGGER.info("【aliOSS】提交音视频剪切作业.<START>.[fileName]=" + fileName + ",[seek]=" + seek + ",[duration]=" + duration);
        fileName = MD5.getMD5StrLower(fileName);
        String inObjectKey = getInObjectKey(AliyunEnum.CUT, fileName, fileType);
        OSSFileDO inputFile = uploadFileStream2OSS(new ByteArrayInputStream(buff), AliyunConstant.FILE_BUCKET,
                inObjectKey);
        String outObjectKey = getOutObjectKey(AliyunEnum.CUT, fileName, "mp4");
        String resultFileUrl = clipJob(inputFile, outObjectKey, seek, duration);
        LOGGER.info("【aliOSS】提交音视频剪切作业.<END>.[resultFileUrl]=" + resultFileUrl);
        return resultFileUrl;
    }*/

    /**
     * 视频剪切作业
     *
     * @param inputFile
     * @param outObjectKey
     * @param seek         开始时间：［0.000,86399.999］
     * @param duration     持续时长 ［0.000,86399.999］
     * @return
     * @throws FileException
     */
    /*private static String clipJob(OSSFileDO inputFile, String outObjectKey, String seek, String duration)
            throws FileException {
        try {
            outObjectKey = URLEncoder.encode(outObjectKey, "utf-8");
        } catch (UnsupportedEncodingException e) {
            LOGGER.error("【aliOSS】cutJob URL encode failed:" + e.getMessage(), e);
            throw new FileException(FileException.FILE_CONVERT_FAIL, "cutJob URL encode failed");
        }
        String inputBucketName = inputFile.getBucket();
        String outputBucketName = AliyunConstant.getOutBucket(inputBucketName);
        // 组装转码参数
        JSONObject jobConfig = new JSONObject();
        jobConfig.put("OutputObject", outObjectKey);
        jobConfig.put("TemplateId", AliyunConstant.getMp4TemplateId(inputBucketName));
        jobConfig.put("Clip", generateClipInput(seek, duration));
        JSONArray jobConfigArray = new JSONArray();
        jobConfigArray.add(jobConfig);
        // 组装输出参数
        SubmitJobsRequest request = new SubmitJobsRequest();
        request.setInput(inputFile.toJsonString());
        request.setOutputBucket(outputBucketName);
        request.setOutputs(jobConfigArray.toJSONString());
        request.setPipelineId(AliyunConstant.getPipelineId(inputBucketName));
        request.setOutputLocation(AliyunConstant.getOssRegion(inputBucketName));
        Integer outputJobCount = 1;

        String object = null;
        try {
          *//*  SubmitJobsResponse response = getAcsClient(inputBucketName).getAcsResponse(request);
            if (response.getJobResultList().size() != outputJobCount) {
                throw new RuntimeException("SubmitJobsRequest Size failed");
            }
            object = response.getJobResultList().get(0).getJob().getOutput().getOutputFile().getObject();
            object = URLDecoder.decode(object, "UTF-8");*//*
        } catch (Exception e) {
            LOGGER.error("【aliOSS】视频剪辑作业失败:" + e.getMessage(), e);
        }
        return getOSSUrl(object, outputBucketName);
    }*/

    /**
     * 组装剪切参数
     *
     * @param seek     开始时间：sssss[.SSS]
     * @param duration 持续时长 sssss[.SSS]
     * @return
     */
   /* private static JSONObject generateClipInput(String seek, String duration) {
        LOGGER.info("【aliOSS】组装剪切参数.<START>.[seek]=" + seek + ",[duration]=" + duration);
        JSONObject input = new JSONObject();
        input.put("Seek", seek);
        input.put("Duration", duration);
        JSONObject timeSpanObject = new JSONObject();
        timeSpanObject.put("TimeSpan", input);
        LOGGER.info("【aliOSS】组装剪切参数.<END>");
        return timeSpanObject;
    }
*/
    /**
     * 提交视频截图任务,成功返回图片地址 <br>
     *
     * @param fileUrl
     * @param time    秒
     * @return 成功:图片地址,失败:null
     */
   /* public static String submitSnapshotJob(String fileUrl, int time) {
        LOGGER.info("【aliOSS】提交MP4截图作业,<START>.[fileUrl]=" + fileUrl);
        String fileType = FileUtils.getFileType(fileUrl);
        if (!FileUtils.VIDEO.equals(FileUtils.getGatherName(fileType))) {
            return null;
        }
        if (!StringTools.contains(fileUrl, AliyunConstant.OSS_CDN_URLS)) {
            return null;
        }
        String inputBucketName = AliyunConstant.getBucketName(fileUrl);
        String objectKey = splitObjectKey(fileUrl);
        try {
            SubmitSnapshotJobRequest request = new SubmitSnapshotJobRequest();
            request.setInput(generateSnapshotInput(inputBucketName, objectKey).toJSONString());
            String outObjectKey = getOutObjectKey(AliyunEnum.SNAPSHOT, null, ImageTypeEnum.JPG.value);
            String outputBucketName = AliyunConstant.FILE_BUCKET;
            request.setSnapshotConfig(generateSnapshotConfig(outputBucketName, outObjectKey, time).toJSONString());
            request.setPipelineId(AliyunConstant.getPipelineId(inputBucketName));
            SnapshotJob snapshotJob = new SnapshotJob();
            getAcsClient(inputBucketName).getAcsResponse(request).getSnapshotJob();
            if ("Success".equalsIgnoreCase(snapshotJob.getState())) {
                String outObject = URLDecoder.decode(snapshotJob.getSnapshotConfig().getOutputFile().getObject(),
                        "UTF-8");
                return getOSSUrl(outObject, outputBucketName);
            }
        } catch (Exception e) {
            LOGGER.error("【aliOSS】视频截图失败:" + e.getMessage(), e);
        }
        return null;
    }*/


    /**
     * 提交视频截图任务,成功返回图片地址
     *
     * @author：zhuyajie
     * @date：2020/6/1 20:08 * @param null
     */
    public static String submitSnapshotJob(String fileUrl, int time) {
        LOGGER.info("【aliOSS】提交MP4截图作业,<START>.[fileUrl]=" + fileUrl);
        String fileType = FileUtils.getFileType(fileUrl);
        if (!FileUtils.VIDEO.equals(FileUtils.getGatherName(fileType))) {
            return null;
        }
        if (!StringTools.contains(fileUrl, AliyunConstant.OSS_CDN_URLS)) {
            return null;
        }
        String inputBucketName = AliyunConstant.getBucketName(fileUrl);
        MpcClient mpcClient = getAcsClient(inputBucketName);
        String objectKey = splitObjectKey(fileUrl);

        // 设置创建截图模板的请求参数
        CreateThumbnailRequest createThumbnailRequest = new CreateThumbnailRequest();

        // 设置截图源文件地址
        ObsObjInfo input = new ObsObjInfo();
        //OBS桶名
        input.setBucket(inputBucketName);
        //OBS下媒资路径
        input.setObject(objectKey);
        //OBS桶所在区域
        input.setLocation(AliyunConstant.getOssRegion(inputBucketName));
        createThumbnailRequest.setInput(input);

        // 设置截图后文件存放地址
        String outObjectKey = getTranscodeOutObjectKey(AliyunEnum.SNAPSHOT, ImageTypeEnum.JPG.value);
        String outputBucketName = AliyunConstant.FILE_BUCKET;
        ObsObjInfo output = new ObsObjInfo();
        output.setBucket(outputBucketName);
        output.setObject(outObjectKey);
        output.setLocation(AliyunConstant.getOssRegion(outputBucketName));
        createThumbnailRequest.setOutput(output);

        // 设置截图参数
        CreateThumbnailRequest.ThumbnailPara thumbnailPara = new CreateThumbnailRequest.ThumbnailPara();
        //采样类型。支持三种采样方式PERCENT、TIME和DOTS(根据时间间隔time，根据视频时长百分比percent，根据时间截图时的时间点数组dots，目前只支持TIME和DOTS两种方式)
        thumbnailPara.setType(CreateThumbnailRequest.ThumbnailPara.TypeEnum.TIME);
        //从视频文件的第“start_time”开始，持续时间为“duration”，每间隔“time”生成一张截图。
        thumbnailPara.setTime(12);
        thumbnailPara.setStartTime(time);
        thumbnailPara.setDuration(3);
        //设置最大长度，范围(380,3840)
        thumbnailPara.setMaxLength(480);
        //设置纵横比(min = 0, max = 1)
        thumbnailPara.setAspectRatio(0);
        //设置截图格式，0表示默认，1表示JPG格式
        thumbnailPara.setFormat(1);
        createThumbnailRequest.setThumbnailPara(thumbnailPara);

        // 发送创建截图任务请求给媒体处理服务
        CreateThumbnailResponse createThumbnailResponse = mpcClient.createThumbnailsTask(createThumbnailRequest);
        // 返回消息
        String taskId = null;
        if ("SUCCESS".equalsIgnoreCase(createThumbnailResponse.getRequestStatus())) {
            taskId = createThumbnailResponse.getTaskId();
        } else {
            return null;
        }
        String outObject = getThumnailObject(outputBucketName, taskId);
        if (!StringUtil.isEmpty(outObject)) {
            return getOSSUrl(outObject, outputBucketName);
        } else {
            return null;
        }
    }

    public static String getThumnailObject(String bucketName, String taskId) {
        int total = 0;
        while (true) {
            // 如果超过1小时,认定转换失败
            if (total > 1 * 60 * 60) {
                return null;
            }
            String object = OssUtils.getThumbnail(bucketName, taskId);
            if (object != null) {
                return object;
            }
            try {
                Thread.sleep(3 * 1000);
            } catch (Exception e) {
                LOGGER.error("【视频截图】进入休眠状态失败: " + e.getMessage(), e);
                throw new FileException(FileException.FILE_CONVERT_FAIL, "获取视频截图失败");
            }
            total += 3;
        }
    }

    private static String getThumbnail(String bucketName, String taskId) {
        if (StringUtil.isEmpty(taskId)) {
            return null;
        }
        MpcClient mpcClient = getAcsClient(bucketName);
        // 设置创建水印模板的请求参数
        QueryThumbTaskRequest queryThumbTaskRequest = new QueryThumbTaskRequest();
        //根据任务ID查询，最多支持10个任务ID
        queryThumbTaskRequest.setTaskId(new String[]{taskId});
        String outObject = null;
        try {
            // 发送查询截图任务请求给媒体处理服务
            QueryThumbTaskResponse queryThumbTaskResponse = mpcClient.queryThumbnailsTask(queryThumbTaskRequest);
            // 返回消息
            if (ListUtils.isEmpty(queryThumbTaskResponse.getTaskArray())) {
                return outObject;
            }
            if (QueryThumbTaskResponse.ThumbTask.StatusEnum.SUCCEEDED.equals(queryThumbTaskResponse.getTaskArray().get(0).getStatus())) {
                QueryThumbTaskResponse.ThumbTask thumbTask = queryThumbTaskResponse.getTaskArray().get(0);
                if (!ListUtils.isEmpty(thumbTask.getThumbnailInfo())) {
                    String picName = thumbTask.getThumbnailInfo().get(0).getPicName();
                    outObject = URLDecoder.decode(thumbTask.getOutput().getObject() + "/" + picName, "UTF-8");
                } else {
                    outObject = "https://oss.5rs.me/oss/uploadfe/jpg/d026cd83cf2ff55e3f4b4493a6919712.jpg";//默认图
                }
            }
        } catch (Exception e) {
            LOGGER.error("【aliOSS】查询视频截图任务失败：" + e.getMessage(), e);
        }
        return outObject;
    }


    /**
     * 组装截图参数
     *
     * @param bucketName
     * @param outputobject
     * @param time
     * @return
     */
   /* private static JSONObject generateSnapshotConfig(String bucketName, String outputobject, int time) {
        JSONObject snapshotConfig = new JSONObject();
        JSONObject output = generateSnapshotInput(bucketName, outputobject);
        snapshotConfig.put("OutputFile", output);
        time = Math.abs(time);
        snapshotConfig.put("Time", (time == 0 ? 1 : time) * 1000);
        // 截图类型，普通帧：normal，I帧：intra，默认值intra
        snapshotConfig.put("FrameType", "normal");
        return snapshotConfig;
    }*/

    /**
     * 组装截图参数
     *
     * @param bucketName
     * @param inputObject
     * @return
     */
  /*  private static JSONObject generateSnapshotInput(String bucketName, String inputObject) {
        JSONObject input = new JSONObject();
        input.put("Location", AliyunConstant.OSS_REGION);
        input.put("Bucket", bucketName);
        input.put("Object", inputObject);
        return input;
    }*/

    /**
     * 组装转换后的地址(华东地区) new
     */
    public static UploadResultInfo getOSSResult(String transcodeJobId) throws FileException {
        LOGGER.info("【aliOSS】组装转换后的地址(华东地区),<START>.[transcodeJobId]=" + transcodeJobId);
        return getOSSResult(transcodeJobId, AliyunConstant.FILE_BUCKET);
    }

    /**
     * 组装转换后的地址,根据BUCKETNAME new
     */
    public static UploadResultInfo getOSSResultByRegion(String transcodeJobId, String buckectName)
            throws FileException {
        if (AliyunConstant.LIVE_BUCKET.equals(buckectName)) {
            return getOSSResult(transcodeJobId, AliyunConstant.LIVE_BUCKET);
        } else {
            return getOSSResult(transcodeJobId, AliyunConstant.FILE_BUCKET);
        }
    }

    /**
     * 组装转换后的地址
     */
    private static UploadResultInfo getOSSResult(String transcodeJobId, String outputBucketName) throws FileException {
        if (StringUtil.isEmpty(transcodeJobId)) {
            return new UploadResultInfo("ali", "ali转码作业失败[transcodeJobId=null]", false);
        }
//        Job transcodeJob = getTranscodeJob(transcodeJobId, outputBucketName);
        QueryTranscodingResponse.QueryTranscodingInfo transcodeJob = getTranscodeJob(transcodeJobId, outputBucketName);
        return explainTranscodeResult(transcodeJob);
    }

    /**
     * 获取转换作业情况
     */
    /*private static Job getTranscodeJob(String transcodeJobId, String bucketName) throws FileException {
        QueryJobListRequest request = new QueryJobListRequest();
        request.setJobIds(transcodeJobId);
        QueryJobListResponse response = null;
        try {
            response = getAcsClient(bucketName).getAcsResponse(request);
            return response.getJobList().get(0);
        } catch (Exception e) {
            LOGGER.error("【aliOSS】获取转换作业情况失败:" + e.getMessage(), e);
            throw new FileException(FileException.FILE_CONVERT_FAIL, "获取转换作业情况失败");
        }
    }*/
    private static QueryTranscodingResponse.QueryTranscodingInfo getTranscodeJob(String transcodeJobId, String bucketName) {
        MpcClient mpcClient = OssUtils.initAcsClient(bucketName);
        //设置查询转码任务ID
        QueryTranscodingRequest queryTranscodingRequest = new QueryTranscodingRequest();
        queryTranscodingRequest.setTaskId(transcodeJobId);
        try {
            //发送查询转码任务请求
            QueryTranscodingResponse queryTranscodingResponse = mpcClient.queryTranscodingTask(queryTranscodingRequest);
            if (null == queryTranscodingResponse || ListUtils.isEmpty(queryTranscodingResponse.getTranscodingArray())) {
                return null;
            }
            return queryTranscodingResponse.getTranscodingArray().get(0);
        } catch (Exception e) {
            LOGGER.error("【aliOSS】获取转换作业情况失败:" + e.getMessage(), e);
            throw new FileException(FileException.FILE_CONVERT_FAIL, "获取转换作业情况失败");
        }
    }


    private static UploadResultInfo explainTranscodeResult(QueryTranscodingResponse.QueryTranscodingInfo transcodingInfo) {
        if (null == transcodingInfo) {
            return null;
        }
        String status = transcodingInfo.getStatus();
        if ("FAILED".equals(status)) {
            LOGGER.warn("【huawei】转换作业失败:[jobId]" + transcodingInfo.getTaskId() + ",[status]=" + status);
            return new UploadResultInfo("ali", "huawei转码作业失败", false);
        }
        if ("SUCCEEDED".equals(status)) {
            QueryTranscodingResponse.QueryTranscodingInfo.Output output = transcodingInfo.getOutput();
            String bucketName = output.getBucket();
            String objectKey = null;
            String outputFileName = transcodingInfo.getOutputFileNames().get(0);
            try {
                objectKey = URLDecoder.decode(output.getObject() + "/" + outputFileName, "UTF-8");
            } catch (Exception e) {
                LOGGER.error("【aliOSS】组装转换后的地址失败:" + e.getMessage(), e);
                return new UploadResultInfo("ali", "huawei转码作业失败", false);
            }
            // 文件大小
            Long fileSize = transcodingInfo.getTranscodeDetail().getMultitaskInfo().get(0).getOutputFile().getSize();
            // 视频时长 音频时长
            Integer duration = transcodingInfo.getTranscodeDetail().getMultitaskInfo().get(0).getOutputFile().getDuration();
            return getResultInfo(objectKey, fileSize, duration.toString(), bucketName);
        }
        return null;
    }
    /**
     * 解析转换后的结果
     *
     * @param transcodeJob
     * @return
     */
   /* private static UploadResultInfo explainTranscodeResult(Job transcodeJob) {
        String status = transcodeJob.getState();
        if ("TranscodeFail".equals(status)) {
            LOGGER.warn("【aliOSS】转换作业失败:[jobId]" + transcodeJob.getJobId() + ",[status]=" + status);
            return new UploadResultInfo("ali", "ali转码作业失败", false);
        }
        if ("TranscodeSuccess".equals(status)) {
            Job.Output output = transcodeJob.getOutput();
            String bucketName = output.getOutputFile().getBucket();
            String objectKey = null;
            try {
                objectKey = URLDecoder.decode(output.getOutputFile().getObject(), "UTF-8");
            } catch (Exception e) {
                LOGGER.error("【aliOSS】组装转换后的地址失败:" + e.getMessage(), e);
                return new UploadResultInfo("ali", "ali转码作业失败", false);
            }
            // 文件大小
            String size = output.getProperties().getFormat().getSize();
            Long fileSize = StringUtil.isEmpty(size) ? null : Long.parseLong(size);
            // 视频时长
            List<VideoStream> videoStreams = output.getProperties().getStreams().getVideoStreamList();
            String duration = null;
            if (!ListUtils.isEmpty(videoStreams)) {
                duration = videoStreams.get(0).getDuration();
            }
            // 音频时长
            List<AudioStream> audioStreams = output.getProperties().getStreams().getAudioStreamList();
            duration = null;
            if (!ListUtils.isEmpty(audioStreams)) {
                duration = audioStreams.get(0).getDuration();
            }
            return getResultInfo(objectKey, fileSize, duration, bucketName);
        }
        return null;
    }*/

    /**
     * 获取媒体信息，仅限经过转码的音视频文件
     */
    public static OssMediaInfoDTO getMediaInfo(String fileUrl) throws FileException {
        LOGGER.info("【aliOSS】获取媒体信息，仅限经过转码的音视频文件,<START>.[fileUrl]=" + fileUrl);
        if (StringUtil.isEmpty(fileUrl)) {
            return null;
        }
        String objectKey = splitObjectKey(fileUrl);
        String bucketName = AliyunConstant.getBucketName(fileUrl);
        ObjectMetadata objectMetadata = null;
        try {
            objectMetadata = getObjectMetadata(objectKey, bucketName);
        } catch (Exception e) {
            LOGGER.error("【aliOSS】获取媒体信息失败:" + e.getMessage(), e);
        }
        if (objectMetadata == null) {
            return null;
        }
        // 封装返回对象
        OssMediaInfoDTO ossMediaInfoDTO = new OssMediaInfoDTO();
        ossMediaInfoDTO.setBucket(bucketName);
        ossMediaInfoDTO.setLocation(AliyunConstant.getOssRegion(bucketName));
        ossMediaInfoDTO.setObejctKey(objectKey);
        ossMediaInfoDTO.setSize(1L);
        ossMediaInfoDTO.setDuration(new BigDecimal(1));
        LOGGER.info("【aliOSS】获取媒体信息，仅限经过转码的音视频文件,<END>.[ossMediaInfoDTO]=" + ossMediaInfoDTO);
        return ossMediaInfoDTO;
    }

    /**
     * 获取文件的元信息
     */
    @SneakyThrows
    public static ObjectMetadata getObjectMetadata(String objectKey, String bucketName) throws FileException {
        // 创建OSSClient实例
        ObsClient ossClient = getOSSClient(bucketName);
        ObjectMetadata objectMetadata = ossClient.getObjectMetadata(bucketName, objectKey);
        // 关闭client
//        ossClient.close();
        return objectMetadata;
    }

    /**
     * 下载文件成byte[]
     */
    public static byte[] downloadFile2Byte(String fileUrl) throws FileException {
        String objectKey = splitObjectKey(fileUrl);
        String bucketName = AliyunConstant.getBucketName(fileUrl);
        // OSSClient实例
        ObsClient ossClient = null;
        InputStream is = null;
        ByteArrayOutputStream os = null;
        byte[] result = null;
        try {
            ossClient = getOSSClient(bucketName);
            ObsObject ossObject = ossClient.getObject(bucketName, objectKey);
            is = ossObject.getObjectContent();
            os = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            int rc = 0;
            while ((rc = is.read(buff, 0, 1024)) != -1) {
                os.write(buff, 0, rc);
            }
            result = os.toByteArray();

        } catch (Exception e) {
            LOGGER.error("【aliOSS】下载文件失败:" + e.getMessage(), e);
            throw new FileException(FileException.FILE_DOWNLOAD_FAILURE, "下载文件失败");
        } finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                if (ossClient != null) {
//                    ossClient.close();
                }
            } catch (Exception e) {
                LOGGER.error("【aliOSS】下载文件，关闭文件流失败:" + e.getMessage(), e);
            }
        }
        return result;
    }

    /**
     * 下载文件到本地()
     */
    @SneakyThrows
    public static void downloadFile(String fileUrl, String outFilePath) throws FileException {
        String objectKey = splitObjectKey(fileUrl);
        String bucketName = AliyunConstant.getBucketName(fileUrl);
        try {
            downloadPointFile2OSS(fileUrl, outFilePath, bucketName, objectKey);
        } catch (Exception e) {
            LOGGER.error("【aliOSS】下载文件失败:" + e.getMessage(), e);
            //下载失败再次尝试断点下载
            downloadPointFile2OSS(fileUrl, outFilePath, bucketName, objectKey);
        }
    }

    /**
     * 组装返回的文件信息 <br> isPrivateKey=true,表示地址可下载,但需要加上密钥,密钥生产使用方法getHashValue或者addUrlKey <br>
     */
    private static UploadResultInfo getResultInfo(String objectKey, Long size, String duration,
                                                  String outputBucketName) {
        UploadResultInfo uploadResultInfo = new UploadResultInfo();
        uploadResultInfo.setObjectKey(objectKey);
        uploadResultInfo.setUrl(getOSSUrl(objectKey, outputBucketName));
        if (size == null) {
            uploadResultInfo.setSize(getObjectMetadata(objectKey, outputBucketName).getContentLength());
        } else {
            uploadResultInfo.setSize(size);
        }
        uploadResultInfo.setFileName(FileUtils.getFileName(objectKey));
        uploadResultInfo.setFileId("huawei");
        uploadResultInfo.setFlag(true);
        uploadResultInfo.setFinish(true);
        if (!StringUtil.isEmpty(duration)) {
            // 20190930 韩双力保留四位
            uploadResultInfo.setDuration(new BigDecimal(duration));
        }
        return uploadResultInfo;
    }

    /**
     * 组装转换后的地址
     */
    private static String getOSSUrl(String objectKey, String outputBucketName) {
        if (StringUtil.isEmpty(objectKey)) {
            return null;
        }
        return AliyunConstant.getOSSCDNUrl(outputBucketName) + objectKey;
    }

    /**
     * 从完整的HTTP路径中截取objectName
     */
    public static String splitObjectKey(String fileUrl) {
        LOGGER.info("【aliOSS】从完整的HTTP路径中截取objectKey,<START>.[fileUrl]=" + fileUrl);
        if (StringUtil.isEmpty(fileUrl)) {
            throw new FileException(FileException.FILE_TYPE_ERROR, "不是有效的文件路径");
        }
        if (!fileUrl.startsWith("http")) {
            return fileUrl;
        }
        if (fileUrl.startsWith("oss/")) {
            return fileUrl;
        }
        if (!StringTools.contains(fileUrl, AliyunConstant.OSS_CDN_URLS)) {
            throw new FileException(FileException.FILE_TYPE_ERROR, "不是有效的文件路径");
        }
        if (fileUrl.contains("?auth_key=")) {
            fileUrl = fileUrl.substring(0, fileUrl.indexOf("?auth_key="));
        }
        if (fileUrl.contains("?x-oss-process=")) {
            fileUrl = fileUrl.substring(0, fileUrl.indexOf("?x-oss-process="));
        }
        if (fileUrl.startsWith("http")) {
            fileUrl = StringTools.replace(fileUrl, AliyunConstant.OSS_CDN_URLS, "");
        }
        LOGGER.info("【aliOSS】从完整的HTTP路径中截取objectKey,<END>.[fileUrl]=" + fileUrl);
        return fileUrl;
    }

    /**
     * 组装输入文件Object路径
     */
    private static String getInObjectKey(AliyunEnum aliyunEnum, String fileName, String fileType) {
        return getObjectKey(aliyunEnum, fileName, fileType);
    }

    /**
     * 组装输出文件Object路径
     */
    private static String getOutObjectKey(AliyunEnum aliyunEnum, String fileName, String fileType) {
        return getObjectKey(aliyunEnum, fileName, fileType);
    }


    /**
     * 组装输出文件Object路径-转码
     */
    private static String getTranscodeOutObjectKey(AliyunEnum aliyunEnum, String fileType) {
        //用于“output”时，只需指定到转码结果期望存放的路径。
        String gatherName = FileUtils.getGatherName(fileType);
        gatherName = StringUtil.isEmpty(gatherName) ? "other" : gatherName.toLowerCase();
        return new StringBuilder("oss/").append(aliyunEnum.value).append("/").append(gatherName).append("/")
                .append(fileType).append("/").toString();
    }

    /**
     * 组装ObjectKey
     */
    private static String getObjectKey(AliyunEnum aliyunEnum, String fileName, String fileType) {
        fileName = StringUtil.isEmpty(fileName) ? UUIDUitl.taskName()
                : (FileUtils.formatName(fileName) + "_" + LocalDateUtils.getYmdhmss());
        String gatherName = FileUtils.getGatherName(fileType);
        gatherName = StringUtil.isEmpty(gatherName) ? "other" : gatherName.toLowerCase();
        return new StringBuilder("oss/").append(aliyunEnum.value).append("/").append(gatherName).append("/")
                .append(fileType).append("/").append(fileName).append(".").append(fileType).toString();
    }

    /**
     * 获取文件下载加密密钥，默认有效期48小时 <br> 密钥需要结合域名https://download.5rs.me使用，可以在浏览器直接下载 <br>
     */
    public static String getHashValue(String fileUrl) {
        return getHashValue(fileUrl, AliyunConstant.OSS_DEFAULT_TIME);
    }

    /**
     * 获取文件下载加密密钥，长期有效 <br> 密钥需要结合域名https://download.5rs.me使用，可以在浏览器直接下载 <br>
     */
    public static String getHashValueLong(String fileUrl) {
        return getHashValue(fileUrl, AliyunConstant.OSS_LONG_TIME);
    }

    /**
     * 获取文件下载加密密钥 <br> 密钥需要结合域名https://download.5rs.me使用，可以在浏览器直接下载 <br>
     *
     * @param second 秒，地址有效期
     */
    public static String getHashValue(String fileUrl, long second) {
        String objectKey = splitObjectKey(fileUrl);
        if (!objectKey.startsWith("/")) {
            objectKey = "/" + objectKey;
        }
        // 有效期,默认48小时。为什么要减1800，是因为阿里云比较坑，默默得在有效期上加了1800s，如果不减的话，设置1分钟过期，实际是31分钟后才过期。
        long timestamp = DateUtils.addNowTimeSecond(second) - 1800;
        // 针对路径中含有中文的，要单独Encode编码。是因为阿里云实在太坑了，他们的代码中未对中文进行UTF-8编码，却默认进行了URLEncode编码，导致最后的MD5加密不一直。
        objectKey = ZSEncode.encodeURI(objectKey);
        String key = MD5.getMD5StrLower(objectKey + "-" + timestamp + "-0-0-" + AliyunConstant.OSS_PRIVATE_KEY);
        return "?auth_key=" + timestamp + "-0-0-" + key;
    }

    /**
     * 将文件URL生成带密钥的地址，可以在浏览器直接访问 <br> 默认有效期48小时
     *
     * @param fileUrl 文件URL全路径地址
     */
    public static String urlAddKey(String fileUrl) {
        return urlAddKey(fileUrl, AliyunConstant.OSS_DEFAULT_TIME);
    }

    /**
     * 将文件URL生成带密钥的地址，可以在浏览器直接访问 <br> 长期有效
     *
     * @param fileUrl 文件URL全路径地址
     */
    public static String urlAddKeyLong(String fileUrl) {
        return urlAddKey(fileUrl, AliyunConstant.OSS_LONG_TIME);
    }

    /**
     * 将文件URL生成带密钥的地址，可以在浏览器直接访问 <br>
     *
     * @param fileUrl 文件URL全路径地址
     * @param second  秒，地址有效期
     */
    public static String urlAddKey(String fileUrl, long second) {
        String result = keyCheckFile(fileUrl);
        return ZSEncode.encodeURI(result) + getHashValue(result, second);
    }

    /**
     * 将文件URL生成带密钥的地址，可以在浏览器直接访问(不转义中文) <br>
     *
     * @param fileUrl 文件URL全路径地址
     * @param second  秒，地址有效期
     */
    public static String urlAddKeyChina(String fileUrl, long second) {
        String result = keyCheckFile(fileUrl);
        return result + getHashValue(result, second);
    }

    private static String keyCheckFile(String fileUrl) {
        if (StringUtil.isEmpty(fileUrl)) {
            return null;
        }
        if (!(StringTools.contains(fileUrl, AliyunConstant.RAYS_CDN_URLS)
                || fileUrl.contains(AliyunConstant.FILE_CDN_URL_DOWNLOAD))) {
            return fileUrl;
        }
        if (fileUrl.contains("?auth_key=")) {
            return fileUrl;
        }
        // 替换域名为可访问的
        return StringTools.replace(fileUrl, AliyunConstant.RAYS_CDN_URLS, AliyunConstant.FILE_CDN_URL_DOWNLOAD);
    }

    /**
     * 将文件URL生成带密钥的下载地址,返回的地址不带域名 <br> 默认有效期48小时
     *
     * @param fileUrl 文件URL全路径地址
     */
    public static String urlAddKey2Sms(String fileUrl) {
        return urlAddKey2Sms(fileUrl, AliyunConstant.OSS_DEFAULT_TIME);
    }

    /**
     * 将文件URL生成带密钥的下载地址,返回的地址不带域名 <br> 长期有效
     *
     * @param fileUrl 文件URL全路径地址
     */
    public static String urlAddKeyLong2Sms(String fileUrl) {
        return urlAddKey2Sms(fileUrl, AliyunConstant.OSS_LONG_TIME);
    }

    /**
     * 将文件URL生成带密钥的下载地址,返回的地址不带域名 <br>
     *
     * @param fileUrl 文件URL全路径地址
     * @param second  秒，地址有效期
     */
    public static String urlAddKey2Sms(String fileUrl, long second) {
        String keyUrl = urlAddKey(fileUrl, second);
        String shortUrl = UrlUtils.getShortUrl(keyUrl);
        return StringUtil.isEmpty(shortUrl) ? keyUrl : shortUrl.replace(UrlConstant.TB_SHORT_URL, "");
    }

    /**
     * 将文件URL生成带密钥的下载地址,返回的地址不带域名 <br>
     */
    public static String urlAddKeyLong2SmsOwn(String fileUrl) {
        String keyUrl = urlAddKeyChina(fileUrl, AliyunConstant.OSS_LONG_TIME);
        String shortUrl = UrlUtils.getShortUrl4Own(keyUrl);
        return StringUtil.isEmpty(shortUrl) ? keyUrl : shortUrl.replace(UrlConstant.OWN_SHORT_URL, "");
    }

    /**
     * 将文件URL生成带密钥的地址，可以在浏览器直接访问,并转换为短链接<br>
     *
     * @param fileUrl 文件URL全路径地址
     */
    public static String urlAddKey2Short(String fileUrl) {
        return urlAddKey2Short(fileUrl, AliyunConstant.OSS_DEFAULT_TIME);
    }

    /**
     * 将文件URL生成带密钥的地址,可以在浏览器直接访问 ,并转换为短链接<br> 长期有效
     *
     * @param fileUrl 文件URL全路径地址
     */
    public static String urlAddKeyLong2Short(String fileUrl) {
        return urlAddKey2Short(fileUrl, AliyunConstant.OSS_LONG_TIME);
    }

    /**
     * 将文件URL生成带密钥的地址,可以在浏览器直接访问,并转换为短链接<br>
     *
     * @param fileUrl 文件URL全路径地址
     * @param second  秒，地址有效期
     */
    public static String urlAddKey2Short(String fileUrl, long second) {
        String keyUrl = urlAddKeyChina(fileUrl, second);
        String shortUrl = UrlUtils.getShortUrl4Own(keyUrl);
        return StringUtil.isEmpty(shortUrl) ? keyUrl : shortUrl;
    }

    /**
     * 图片缩放,按宽度等比例缩放
     *
     * @param width 目前最大支持1024，超过1024或者小于0都按1024计算
     * @return 返回处理后的图片本地地址
     */
    public static String imageWidthResize(String fileUrl, int width) throws FileException {
        LOGGER.info("【aliOSS】图片缩放,<START>.[fileUrl]=" + fileUrl + ",[width]=" + width);
        ImageUtils.checkIsImage(fileUrl);
        // 图片缩放大小字体大小,偏移量
        if (width < 1 || width > 4096) {
            throw new FileException(FileException.PARAM_ERROR, "缩放后图片的宽度必须介于(0,4096]之间");
        }
        StringBuilder style = new StringBuilder("image/resize");
        style.append(",m_fixed,w_").append(width);
        // 生成新的图片地址
        String localPath = imageHandle(fileUrl, style.toString());
        LOGGER.info("【aliOSS】图片缩放,<START>.[localPath]=" + localPath);
        return localPath;
    }

    /**
     * 图片缩放,按倍数百分比缩放
     *
     * @param p 1-1000，倍数百分比。 小于100，即是缩小，大于100即是放大。
     * @return 返回处理后的图片本地地址
     */
    public static String imageResize(String fileUrl, int p) throws FileException {
        LOGGER.info("【aliOSS】图片缩放,<START>.[fileUrl]=" + fileUrl + ",[p]=" + p);
        ImageUtils.checkIsImage(fileUrl);
        // 图片缩放大小字体大小,偏移量
        if (p < 1 || p > 1000) {
            p = 100;
        }
        StringBuilder style = new StringBuilder("image/resize");
        style.append(",p_").append(p);
        // 生成新的图片地址
        String localPath = imageHandle(fileUrl, style.toString());
        LOGGER.info("【aliOSS】图片缩放,<START>.[localPath]=" + localPath);
        return localPath;
    }

    /**
     * 图片自动旋转
     *
     * @param width 图片旋转以后的宽度，最大不能超过4096,传0则按原始宽度旋转
     * @return 返回处理后的图片本地地址
     */
    public static String imageAutoOrient(String fileUrl, int width) throws FileException {
        LOGGER.info("【aliOSS】图片自动旋转,<START>.[fileUrl]=" + fileUrl);
        ImageUtils.checkIsImage(fileUrl);
        // 图片缩放大小字体大小,偏移量
        if (width < 0 || width > 4096) {
            throw new FileException(FileException.PARAM_ERROR, "旋转后的图片的宽度必须介于[0,4096]之间");
        }
        StringBuilder style = new StringBuilder("image");
        if (width > 0) {
            style.append("/resize,w_").append(width);
        }
        style.append("/auto-orient,1");
        // 生成新的图片地址
        String localPath = imageHandle(fileUrl, style.toString());
        LOGGER.info("【aliOSS】图片自动旋转,<START>.[localPath]=" + localPath);
        return localPath;
    }

    /**
     * 图片裁剪,如果图片带有旋转属性，会自动旋转纠正角度后在进行裁剪。
     *
     * @param width  裁剪的宽度
     * @param height 裁剪的高度
     * @param x      左上角开始， 裁剪的X轴坐标
     * @param y      左上角开始， 裁剪的Y轴坐标
     * @return 返回处理后的图片本地地址
     */
    public static String imageCrop(String fileUrl, int width, int height, int x, int y) throws FileException {
        LOGGER.info("【aliOSS】图片裁剪,<START>.[fileUrl]=" + fileUrl);
        ImageUtils.checkIsImage(fileUrl);
        if (!(width >= 0 && width <= 4096 && height >= 0 && height <= 4096 && x >= 0 && y >= 0)) {
            throw new FileException(FileException.PARAM_ERROR, "裁剪的长宽或者坐标数值必须大于0且长宽必须小于4096");
        }
        StringBuilder style = new StringBuilder("image/auto-orient,1/crop");
        style.append(",w_").append(width);
        style.append(",h_").append(height);
        style.append(",x_").append(x);
        style.append(",y_").append(y);
        // 生成新的图片地址
        String localPath = imageHandle(fileUrl, style.toString());
        LOGGER.info("【aliOSS】图片裁剪,<END>.[localPath]=" + localPath);
        return localPath;
    }

    /**
     * <持久化>图片裁剪，如果图片带有旋转属性，会自动旋转纠正角度后在进行裁剪。
     */
    @SneakyThrows
    public static OssImageCropDTO imageCropSaveas(String fileUrl, int width, int height, int x, int y)
            throws FileException {
        LOGGER.info("【aliOSS】图片裁剪持久化,<START>.[fileUrl]=" + fileUrl);
        ImageUtils.checkIsImage(fileUrl);
        if (!(width >= 0 && width <= 4096 && height >= 0 && height <= 4096 && x >= 0 && y >= 0)) {
            throw new FileException(FileException.PARAM_ERROR, "裁剪的长宽或者坐标数值必须大于0且长宽必须小于4096");
        }
        String fileType = FileUtils.getFileType(fileUrl);
        String bucketName = AliyunConstant.getBucketName(fileUrl);
        String sourceKey = splitObjectKey(fileUrl);
        StringBuilder style = new StringBuilder("image/auto-orient,1/crop");
        style.append(",w_").append(width);
        style.append(",h_").append(height);
        style.append(",x_").append(x);
        style.append(",y_").append(y);
        // 创建OSSClient实例
        ObsClient ossClient = getOSSClient(bucketName);
        TemporarySignatureRequest temporarySignatureRequest = new TemporarySignatureRequest();
        temporarySignatureRequest.setObjectKey(sourceKey);
        Map<String, Object> queryParams = new HashMap<>();
        queryParams.put("x-image-process", style.toString());
        queryParams.put("x-image-save-object", ServiceUtils.toBase64(sourceKey.getBytes("UTF-8")));
        queryParams.put("x-image-save-bucket", ServiceUtils.toBase64(bucketName.getBytes("UTF-8")));
        temporarySignatureRequest.setQueryParams(queryParams);
        temporarySignatureRequest.setBucketName(bucketName);
        TemporarySignatureResponse response = ossClient.createTemporarySignature(temporarySignatureRequest);
        //访问的url
        String url = response.getSignedUrl();
        LOGGER.info(url);
        OssImageCropDTO ossImageCropDTO = new OssImageCropDTO();
        try {
            ossImageCropDTO.setBucket(bucketName);
            ossImageCropDTO.setObject(sourceKey);
            ossImageCropDTO.setFileUrl(url);
        } catch (Exception e) {
            LOGGER.error("【aliOSS】图片裁剪持久化失败:" + e.getMessage(), e);
        }
        return ossImageCropDTO;
    }

    /**
     * 图片处理
     */
    @SneakyThrows
    private static String imageHandle(String fileUrl, String style) {
        String fileType = FileUtils.getFileType(fileUrl);
        String key = splitObjectKey(fileUrl);
        String bucketName = AliyunConstant.getBucketName(fileUrl);
        GetObjectRequest request = new GetObjectRequest(bucketName, key);
        request.setImageProcess(style);
        // 创建OSSClient实例
        ObsClient ossClient = getOSSClient(bucketName);
        // 生成新的图片地址
        String localPath = FilePathConstant.IMAGE + UUIDUitl.generateString(32) + "." + fileType;
        FileUtils.creatFiles(localPath);
        try {
            ObsObject obsObject = ossClient.getObject(request);
            obsObjectToLocalFile(localPath, obsObject);
        } catch (Exception e) {
            FileUtils.deleteFile(localPath);
            LOGGER.error("【aliOSS】图片处理API:" + e.getMessage(), e);
        } finally {
//            ossClient.close();
        }
        return localPath;
    }

    private static void obsObjectToLocalFile(String localPath, ObsObject obsObject) throws IOException {
        InputStream input = null;
        FileOutputStream downloadFile = null;
        try {
            input = obsObject.getObjectContent();
            int index;
            byte[] bytes = new byte[1024];
            downloadFile = new FileOutputStream(localPath);
            while ((index = input.read(bytes)) != -1) {
                downloadFile.write(bytes, 0, index);
                downloadFile.flush();
            }
        } catch (IOException e) {
            LOGGER.error("obsObjectToLocalFile失败");
        } finally {
            input.close();
            downloadFile.close();
        }
    }

    /**
     * 图片增加水印
     *
     * @return 返回处理后的图片网络地址
     */
    public static String imageWatermark(String fileUrl, String watermarkContent) throws FileException {
        LOGGER.info("【aliOSS】图片增加水印,<START>.[fileUrl]=" + fileUrl + ",[watermarkContent]=" + watermarkContent);
        if (StringUtil.isEmpty(watermarkContent)) {
            throw new FileException(FileException.PARAM_ERROR, "水印内容不能为空");
        }
        ImageUtils.checkIsImage(fileUrl);
        StringBuilder style = new StringBuilder("image/watermark");
        // 水印文本,需要转换成base64格式
        style.append(",text_" + new String(Base64.encode(watermarkContent.getBytes())));
        // 水印字体大小,位置,偏移量
        style.append(",size_60,g_se,x_20,y_20");
        // 生成新的图片地址
        String localPath = imageHandle(fileUrl, style.toString());
        // 上传处理后的图片,并删除本地文件
        UploadResultInfo uploadResultInfo = uploadLocalFile(localPath, null);
        FileUtils.deleteFile(localPath);
        return uploadResultInfo == null ? null : uploadResultInfo.getUrl();
    }

    /**
     * 图片增加水印(文本)
     *
     * @param ossImageDTO 原图地址
     */
    public static String imageWatermark4Text(OssImageDTO ossImageDTO) {
        LOGGER.info("【aliOSS】图片增加水印(文本),<START>.[ossImageDTO]=" + ossImageDTO);
        String text = ossImageDTO.getText();
        if (StringUtil.isEmpty(text)) {
            throw new IllegalArgumentException("水印内容不能为空");
        }
        String fileUrl = ossImageDTO.getFileUrl();
        // 检查文件合法性
        fileUrl = checkImageFileUrl(fileUrl);
        // 水印文本
        StringBuilder style = new StringBuilder("image/watermark");
        style.append(",text_" + new String(Base64.encode(text.getBytes())));
        // 水印字体大小,如果小于1，自动计算文字大小2
        int size = ossImageDTO.getSize();
        style.append(",size_").append(size < 1 ? caleImageFontSize(fileUrl) : size);
        // 水印颜色，默认使用白色
        String color = ossImageDTO.getColor();
        style.append(",color_").append(StringUtil.isEmpty(color) ? "FFFFFF" : color);
        // 区域位置
        String g = ossImageDTO.getG();
        if (!StringUtil.isEmpty(g)) {
            style.append(",g_").append(g);
        }
        // 偏移量,x和y坐标
        style.append(",x_").append(ossImageDTO.getX()).append(",y_").append(ossImageDTO.getY());
        // 水印文字阴影透明度
        int shadow = ossImageDTO.getShadow();
        if (shadow > 0) {
            style.append(",shadow_").append(shadow > 100 ? 100 : shadow);
        }
        String result = imageWatermarkHandle(fileUrl, style.toString());
        LOGGER.info("【aliOSS】图片增加水印(文本),<END>.[result]=" + result);
        return result;
    }

    /**
     * 图片增加水印(图片)
     *
     * @param fileUrl           原图地址
     * @param watermarkImageUrl 水印图片地址
     */
    public static String imageWatermark4Image(String fileUrl, String watermarkImageUrl) throws FileException {
        LOGGER.info("【aliOSS】图片增加水印(图片),<START>.[fileUrl]=" + fileUrl + ",[watermarkImageUrl]=" + watermarkImageUrl);
        if (StringUtil.isEmpty(watermarkImageUrl)) {
            throw new FileException(FileException.PARAM_ERROR, "水印内容不能为空");
        }
        StringBuilder style = new StringBuilder("image/watermark");
        // 水印图片地址,按主图大小的10%缩放
        watermarkImageUrl = AliyunConstant.getBucketName(watermarkImageUrl) + "/" + splitObjectKey(watermarkImageUrl);
        style.append(",image_" + new String(Base64.encode(watermarkImageUrl.getBytes())));
        // 水印颜色，位置，偏移量
        style.append(",g_br,t_90,x_10,y_10");
        String result = imageWatermarkHandle(fileUrl, style.toString());
        LOGGER.info("【aliOSS】图片增加水印(图片),<END>.[result]=" + result);
        return result;
    }

    /**
     * 图片水印处理
     */
    @SneakyThrows
    private static String imageWatermarkHandle(String fileUrl, String style) {
        String fileName = FileUtils.getFileName(fileUrl);
        String fileType = FileUtils.getFileType(fileUrl);
        String key = splitObjectKey(fileUrl);
        String bucketName = AliyunConstant.getBucketName(fileUrl);
        GetObjectRequest request = new GetObjectRequest(bucketName, key);
        request.setImageProcess(style);
        // 创建OSSClient实例
        ObsClient ossClient = getOSSClient(bucketName);
        // 生成带水印的本地图片地址
        String localPath = FilePathConstant.IMAGE_WATERMARK + fileName + "_" + LocalDateUtils.getYmdhmss() + "."
                + fileType;
        FileUtils.creatFiles(localPath);
        ObsObject obsObject = ossClient.getObject(request);
        obsObjectToLocalFile(localPath, obsObject);
//        ossClient.close();
        // 上传处理后的图片,并删除本地文件
        UploadResultInfo uploadResultInfo = uploadLocalFile4CustomName(localPath, fileName);
        FileUtils.deleteFile(localPath);
        return uploadResultInfo == null ? null : uploadResultInfo.getUrl();
    }

    /**
     * 检查图片文件合法性，如果是本地文件先上传
     */
    private static String checkImageFileUrl(String fileUrl) throws BizException {
        LOGGER.info("【aliOSS】检查文件合法性,<START>.[fileUrl]=" + fileUrl);
        String fileType = FileUtils.getFileType(fileUrl);
        if (!FileUtils.IMAGE.equals(FileUtils.getGatherName(fileType))) {
            throw new FileException(FileException.FILE_TYPE_ERROR, "不是有效的图片文件");
        }
        // 如果是本地文件先上传
        if (!fileUrl.startsWith("http")) {
            UploadResultInfo uploadResultInfo = uploadLocalFile(fileUrl, null);
            if (uploadResultInfo != null && uploadResultInfo.isFlag()) {
                fileUrl = uploadResultInfo.getUrl();
            } else {
                throw new FileException(FileException.FILE_CONTENT_NOT_EXIST, "不是有效文件");
            }
        }
        LOGGER.info("【aliOSS】检查文件合法性,<END>.[fileUrl]=" + fileUrl);
        return fileUrl;
    }

    /**
     * 计算图片水印文字大小
     */
    private static Integer caleImageFontSize(String fileUrl) {
        LOGGER.info("【aliOSS】计算图片水印文字大小,<START>.[fileUrl]=" + fileUrl);
        float imageWidth = ImageUtils.getWidthSize(fileUrl);
        Float result = imageWidth == 0 ? 18 : imageWidth / 750 * 18;
        LOGGER.info("【aliOSS】计算图片水印文字大小,<END>.[result]=" + result);
        return Math.round(result);
    }

    private static final Map<String, ObsClient> OBS_CLIENT_MAP = new HashMap<>();

    /**
     * 获取OSS客户端
     */
    private static ObsClient getOSSClient(String bucketName) {
        if (OBS_CLIENT_MAP.get(bucketName) == null) {
            synchronized (OssUtils.class) {
                if (OBS_CLIENT_MAP.get(bucketName) == null) {
                    long start = System.currentTimeMillis();
                    OBS_CLIENT_MAP.put(bucketName, new ObsClient(AliyunConstant.MAIN_ACCESS_KEY_ID,
                            AliyunConstant.MAIN_ACCESS_KEY_SECRET, AliyunConstant.getOSSEndPoint(bucketName)));
                    LOGGER.warn("ObsClient created,bucket={},cost={}", bucketName, System.currentTimeMillis() - start);
                }
            }
        }
        return OBS_CLIENT_MAP.get(bucketName);
    }

    /**
     * 判断object是否存在
     */
    @SneakyThrows
    private static boolean objectExist(String bucketName, String objectKey) {
        ObsClient ossClient = getOSSClient(bucketName);
        boolean found = ossClient.doesObjectExist(bucketName, objectKey);
        // 关闭client
//        ossClient.close();
        return found;
    }

    /**
     * 判断文件是存在001中
     *
     * @return true:001,false:002
     */
    public static boolean fileUrlExist001(String fileUrl) {
        String objectKey = splitObjectKey(fileUrl);
        return objectExist(AliyunConstant.INPUT_BUCKET, objectKey);
    }

    /**
     * 判断文件是存在002中
     *
     * @return true:001,false:002
     */
    public static boolean fileUrlExist002(String fileUrl) {
        String objectKey = splitObjectKey(fileUrl);
        return objectExist(AliyunConstant.FILE_BUCKET, objectKey);
    }

}
