package com.pcloud.common.core.interceptor;

import com.pcloud.universe.monitor.provider.MonitorInterceptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import com.pcloud.common.core.interceptor.GlobalHandlerInterceptor;

/**
 * 
 * @描述：
 * @作者：songx
 * @创建时间：2017年9月13日,上午11:42:24
 * @版本：1.0
 */
@Configuration
public class GlobalWebMvcConfigurerAdapter extends WebMvcConfigurerAdapter {

	@Value("${spring.application.name}")
	private String appCode;

	@Override
	public void addInterceptors(InterceptorRegistry registry) {

		/**
		 * 监控埋点日志拦截器，需要在第一个
		 */
		registry.addInterceptor(new MonitorInterceptor(appCode));

		registry.addInterceptor(new GlobalHandlerInterceptor());
	}

}
