package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingLinkSendDao;
import com.pcloud.book.advertising.dto.LinkRevertRecordDTO;
import com.pcloud.book.advertising.entity.AdvertisingLinkSend;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：链接发送统计
 * @作者：zhuyajie
 * @创建时间：15:48 2019/10/17
 * @版本：1.0
 */
@Component("advertisingLinkSendDao")
public class AdvertisingLinkSendDaoImpl extends BaseDaoImpl<AdvertisingLinkSend> implements AdvertisingLinkSendDao {

    @Override
    public Map<Long, LinkRevertRecordDTO> mapSendCount(List<Long> linkIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("linkIds", linkIds);
        return getSessionTemplate().selectMap(getStatement("mapSendCount"), map, "id");
    }
}
