package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletBooklistClassifyDao;
import com.pcloud.book.applet.dto.AppletBooklistClassifyDTO;
import com.pcloud.book.applet.entity.AppletBooklistClassify;
import com.pcloud.book.applet.entity.AppletBooklistClassifyUser;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Component
public class AppletBooklistClassifyDaoImpl extends BaseDaoImpl<AppletBooklistClassify> implements AppletBooklistClassifyDao {

    @Override
    public Integer getMaxSeq(Long agentId) {
        Map<String,Object> map = new HashMap<>();
        map.put("agentId", agentId);
        return getSessionTemplate().selectOne(getStatement("getMaxSeq"), map);
    }

    @Override
    public List<AppletBooklistClassifyDTO> getAllBooklistClassify(Boolean showState, Long agentId) {
        Map<String,Object>map=new HashMap<>();
        map.put("showState", showState);
        map.put("agentId", agentId);
        return getSessionTemplate().selectList(getStatement("getAllBooklistClassify"), map);
    }

    @Override
    public void batchInsertUserBooklistClassify(List<AppletBooklistClassifyUser> booklistClassifyUsers) {
        getSessionTemplate().insert(getStatement("batchInsertUserBooklistClassify"), booklistClassifyUsers);
    }

    @Override
    public void deleteClassifyByWechatUesrId(Long wechatUserId) {
        getSessionTemplate().delete(getStatement("deleteClassifyByWechatUesrId"), wechatUserId);
    }

    @Override
    public List<Long> getClassifyIdsByUserId(Long wechatUserId) {
        return getSessionTemplate().selectList(getStatement("getClassifyIdsByUserId"), wechatUserId);
    }

    @Override
    public List<AppletBooklistClassifyDTO> getClassifysByUserId(Long wechatUserId) {
        return getSessionTemplate().selectList(getStatement("getClassifysByUserId"), wechatUserId);
    }
}
