package com.pcloud.book.applet.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@ApiModel("标签信息封装")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AppletBookScoreTagDTO {

    @ApiModelProperty("标签ID")
    private Long tagId;

    @ApiModelProperty("标签名称")
    private String tagName;

    @ApiModelProperty("是否选中")
    private boolean chosen = false;

    @ApiModelProperty("选中时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date chooseTime;

    @ApiModelProperty("二级标签列表")
    private List<AppletBookScoreSubTagDTO> subTags;
}
