package com.pcloud.book.applet.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * (AppletBookIgnor)实体类
 *
 * @author makejava
 * @since 2021-05-06 13:49:58
 */
@Data
public class AppletBookIgnor extends BaseEntity {

    private static final long serialVersionUID = 410246221902136605L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("书籍id")
    private Long bookId;

    @ApiModelProperty("渠道id")
    private Long channelId;

    @ApiModelProperty("编辑id")
    private Long adviserId;

    @ApiModelProperty("bookAdviserId")
    private Long bookAdviserId;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    @ApiModelProperty("是否删除")
    private Integer isDelete;

    private String bookName;

    private String adviserName;

    private String isbn;

    private Long agentId;

    private String agentName;

    private String coverImg;
}