package com.pcloud.book.applet.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * (BuyBookRequest)实体类
 *
 * @author makejava
 * @since 2020-10-14 19:51:40
 */
@Data
public class BuyBookRequest extends BaseEntity {

    private static final long serialVersionUID = -15486229714305004L;

    private Long id;

    private Long bookId;

    private Long adviserId;

    private Long channelId;

    private Long agentId;

    private Long wechatUserId;

    private String userName;

    private String phone;

    private String address;

    @ApiModelProperty("小程序id")
    private Long miniWechatUserId;

    @ApiModelProperty("小程序openId")
    private String miniOpenId;

    @ApiModelProperty("微信昵称")
    private String nickName;

    @ApiModelProperty("是否回复")
    private Integer replyState;

    @ApiModelProperty("是否删除")
    private Integer isDelete;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

}