package com.pcloud.book.book.biz;

import com.pcloud.book.book.entity.BookOther;
import com.pcloud.common.page.PageBeanNew;

/**
 * (BookOther)表服务接口
 *
 * @author makejava
 * @since 2020-12-02 18:56:07
 */
public interface BookOtherBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    BookOther getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param bookOther 实例对象
     * @return 主键
     */
    Long insert(BookOther bookOther);

    /**
     * 修改数据
     *
     * @param bookOther 实例对象
     */
    void update(BookOther bookOther);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    /**
     * 获取其他权益的书籍
     */
    void getOtherBook();
}