package com.pcloud.book.book.biz.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.book.biz.BookFreezeBiz;
import com.pcloud.book.book.biz.BookMinimumSupportBiz;
import com.pcloud.book.book.dao.BookMinimumSupportDao;
import com.pcloud.book.book.dto.BookFreezeDto;
import com.pcloud.book.book.dto.BookMinimumSupportDTO;
import com.pcloud.book.book.dto.BookMinimumSupportDTO4Service;
import com.pcloud.book.book.entity.BookMinimumSupport;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @ClassName com.pcloud.book.book.biz.impl.BookMinimumSupportBizImpl
 * @Author zhuyajie
 * @Description 书刊保底
 * @Date 2020/12/31 16:58
 * @Version 1.0
 **/
@Component
public class BookMinimumSupportBizImpl implements BookMinimumSupportBiz {

    @Autowired
    private BookMinimumSupportDao minimumSupportDao;
    @Autowired
    private BookFreezeBiz bookFreezeBiz;


    @Override
    public void createBookMinimumSupport(BookMinimumSupport bookMinimumSupport) {
        if (null == bookMinimumSupport.getBookId()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "书籍标识码不能为空！");
        }
        if (null == bookMinimumSupport.getStartTime()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "保底支持开始时间不能为空！");
        }
        if (null == bookMinimumSupport.getEndTime()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "保底支持结束时间不能为空！");
        }
        // 判断有效期是否重复
        timeIsExsit(bookMinimumSupport);
        minimumSupportDao.insert(bookMinimumSupport);
    }

    @Override
    public void updateBookMinimumSupport(BookMinimumSupport bookMinimumSupport) {
        if (null == bookMinimumSupport.getBookId()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "书籍标识码不能为空！");
        }
        if (null == bookMinimumSupport.getStartTime()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "保底支持开始时间不能为空！");
        }
        if (null == bookMinimumSupport.getEndTime()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "保底支持结束时间不能为空！");
        }
        BookMinimumSupport support = minimumSupportDao.getById(bookMinimumSupport.getId());
        if (null == support) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "该保底支持不存在！");
        }
        // 判断有效期是否重复
        timeIsExsit(bookMinimumSupport);
        minimumSupportDao.update(bookMinimumSupport);
    }

    /**
     * 判断有效期是否重复
     */
    private void timeIsExsit(BookMinimumSupport bookMinimumSupport) throws BizException {
        Long bookId = bookMinimumSupport.getBookId();
        BookFreezeDto bookFreezeDto = bookFreezeBiz.getBaseById(bookId);
        if (bookFreezeDto != null) {
            throw new BookBizException(BookBizException.ERROR, "该图书已有冻结记录！");
        }
        if (bookMinimumSupport.getStartTime().before(new Date())) {
            throw new BookBizException(BookBizException.ERROR, "开始日期要大于当前日期！");
        }
        List<BookMinimumSupportDTO> supportList = new ArrayList<>();
        if (null == bookMinimumSupport.getId()) {// 新增
           supportList = minimumSupportDao.getByBookId(bookId);
        } else { // 修改
            Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("bookId", bookId);
            paramMap.put("id", bookMinimumSupport.getId());
            supportList = minimumSupportDao.getMinimunListByMap(paramMap);
        }
        if (ListUtils.isEmpty(supportList)) {
            return;
        }
        Long sTime = bookMinimumSupport.getStartTime().getTime();// 未加开始时间
        Long eTime = bookMinimumSupport.getEndTime().getTime();// 未加结束时间
        for (BookMinimumSupportDTO support : supportList) {
            Long startTime = support.getStartTime().getTime();// 已加开始时间
            Long endTime = support.getEndTime().getTime();// 已加结束时间
            if (startTime < sTime && sTime < endTime) {// 未加开始时间不在已加有效期之内，否则重复
                throw new BookBizException(BookBizException.PARAM_IS_EXIST, "保底支持有效期已存在！");
            }
            if (startTime < eTime && eTime < endTime) {// 未加结束时间不在已加有效期之内，否则重复
                throw new BookBizException(BookBizException.PARAM_IS_EXIST, "保底支持有效期已存在！");
            }
            if (sTime < startTime && startTime < eTime) {// 已加开始时间不在未加有效期之内，否则重复
                throw new BookBizException(BookBizException.PARAM_IS_EXIST, "保底支持有效期已存在！");
            }
            if (sTime < endTime && endTime < eTime) {// 已加结束时间不在未加有效期之内，否则重复
                throw new BookBizException(BookBizException.PARAM_IS_EXIST, "保底支持有效期已存在！");
            }
            if (sTime.equals(startTime) && eTime.equals(endTime)) {// 已加有效期与未加有效期相同
                throw new BookBizException(BookBizException.PARAM_IS_EXIST, "保底支持有效期已存在！");
            }

        }
    }

    @Override
    @ParamLog("书刊是否保底支持")
    public Boolean isBookMinimumSupport(Long bookId, String date) {
        if (null == bookId || null == date) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "参数缺失！");
        }
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("date", date);
        List<BookMinimumSupportDTO> minimumSupportDTOS = minimumSupportDao.getByParamMap(paramMap);
        Boolean isOcuppy = false;
        if (!ListUtils.isEmpty(minimumSupportDTOS)) {
            isOcuppy = true;
        }
        return isOcuppy;
    }

    @Override
    public Map<Long, BookMinimumSupportDTO4Service> mapBookMinimunSupport(List<Long> bookIds) {
        Map<Long, BookMinimumSupportDTO4Service> supportDTOMap = new HashMap<>();
        if (ListUtils.isEmpty(bookIds)) {
            return supportDTOMap;
        }
        List<BookMinimumSupportDTO> list = minimumSupportDao.getByBookIds(bookIds);
        if (ListUtils.isEmpty(list)){
            return supportDTOMap;
        }
        Map<Long, List<BookMinimumSupportDTO>> listMap = list.stream().collect(Collectors.groupingBy(BookMinimumSupportDTO::getBookId));
        for (Map.Entry<Long, List<BookMinimumSupportDTO>> entry: listMap.entrySet()){
            BookMinimumSupportDTO4Service supportDTO4Service = new BookMinimumSupportDTO4Service();
            supportDTO4Service.setSupportDTOS(entry.getValue());

            supportDTOMap.put(entry.getKey(), supportDTO4Service);
        }
        return supportDTOMap;
    }
}
