package com.pcloud.book.book.dao.impl;

import com.pcloud.book.book.dao.BookMinimumSupportDao;
import com.pcloud.book.book.dto.BookMinimumSupportDTO;
import com.pcloud.book.book.entity.BookMinimumSupport;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.book.dao.impl.BookMinimumSupportDaoImpl
 * @Author zhuyajie
 * @Description 书刊保底
 * @Date 2020/12/31 16:51
 * @Version 1.0
 **/
@Component
public class BookMinimumSupportDaoImpl extends BaseDaoImpl<BookMinimumSupport> implements BookMinimumSupportDao {
    @Override
    public List<BookMinimumSupportDTO> getByBookId(Long bookId) {
        return getSessionTemplate().selectList(getStatement("getByBookId"), bookId);
    }

    @Override
    public List<BookMinimumSupportDTO> getMinimunListByMap(Map<String, Object> paramMap) {
        return getSessionTemplate().selectList(getStatement("getMinimunListByMap"), paramMap);
    }

    @Override
    public BookMinimumSupportDTO getInfoByBookId(Long bookId) {
        return getSessionTemplate().selectOne(getStatement("getInfoByBookId"), bookId);
    }

    @Override
    public List<BookMinimumSupportDTO> getByParamMap(Map<String, Object> paramMap) {
        return getSessionTemplate().selectList(getStatement("getByParamMap"), paramMap);
    }

    @Override
    public List<BookMinimumSupportDTO> getByBookIds(List<Long> bookIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookIds", bookIds);
        return getSessionTemplate().selectList(getStatement("getByBookIds"), map);
    }
}
