package com.pcloud.book.book.entity;

import java.util.Date;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 新手引导案例书刊删除表(NoviceGuideDelete)实体类
 *
 * @author makejava
 * @since 2021-11-22 11:50:51
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class NoviceGuideDelete extends BaseEntity {

    private static final long serialVersionUID = 928702112675084581L;
    
    @ApiModelProperty("主键id")
    private Long id;
    
    @ApiModelProperty("编辑id")
    private Long adviserId;
    
    @ApiModelProperty("书刊id")
    private Long bookId;
    
    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    
    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    
}