package com.pcloud.book.book.facade;

import com.pcloud.book.book.entity.BookUserBrowseRecord;
import com.pcloud.book.book.biz.BookUserBrowseRecordBiz;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import io.swagger.annotations.ApiOperation;
import com.pcloud.common.utils.cookie.Cookie;

/**
 * 书籍用户关联表(BookUserBrowseRecord)表控制层
 *
 * @author wubo
 * @since 2021-12-03 10:40:19
 */
@RestController("bookUserBrowseRecordFacade")
@RequestMapping("bookUserBrowseRecord")
public class BookUserBrowseRecordFacade {

    @Autowired
    private BookUserBrowseRecordBiz bookUserBrowseRecordBiz;


    @ApiOperation("通过主键查询单条数据")
    @GetMapping("getById")
    public ResponseDto<?> getById(@CookieValue("userInfo") String userInfo,
                                  @RequestParam Long bookId) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(bookUserBrowseRecordBiz.getById(bookId));
    }

    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getList(@CookieValue("userInfo") String userInfo,
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(bookUserBrowseRecordBiz.getList(currentPage, numPerPage));
    }

    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert(@CookieValue("userInfo") String userInfo,
                                 @RequestBody BookUserBrowseRecord bookUserBrowseRecord)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(bookUserBrowseRecordBiz.insert(bookUserBrowseRecord));
    }

    @ApiOperation("更新")
    @PostMapping("update")
    public ResponseDto<?> update(@CookieValue("userInfo") String userInfo,
                                 @RequestBody BookUserBrowseRecord bookUserBrowseRecord) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        bookUserBrowseRecordBiz.update(bookUserBrowseRecord);
        return new ResponseDto<>();
    }

    @ApiOperation("删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@CookieValue("userInfo") String userInfo,
                                     @RequestParam Long bookId) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
         return new ResponseDto<>();
    }

    @ApiOperation("软删除")
    @GetMapping("softDeleteById")
    public ResponseDto<?> softDeleteById(@CookieValue("userInfo") String userInfo,
                                         @RequestParam Long bookId) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>();
    }

}
