package com.pcloud.book.copyright.biz;

import com.pcloud.book.copyright.dto.BookExportRecordDTO;
import com.pcloud.book.copyright.entity.BookExportRecord;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;

/**
 * @author lily
 * @date 2018/12/4 19:14
 */
public interface BookExportRecordBiz {

    /**
     * 新增导出记录
     */
    void insertRecord(BookExportRecord bookExportRecord);

    /**
     * 更新导出记录
     */
    void updateRecordStatus(BookExportRecord bookExportRecord);

    /**
     * 获取是否有正在到处的数据
     */
    Boolean isHaveExport(Long bookId, Long channelId, Long adviserId);

    /**
     * 更新导出记录
     */
    void updateRecord(BookExportRecord bookExportRecord);

    void handleExportFail();


    /**
     * 查看授权码生成记录
     */
    PageBeanNew<BookExportRecordDTO> getGenerateCodeHistory(Long bookId, Long adviserId, Long channelId,Long sceneId, PageParam pageParam);

    /**
     * 获取最后一次导出的地址
     */
    String getExportUrl(Long bookId, Long channelId, Long adviserId,Long sceneId);
}
