package com.pcloud.book.cultivate.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.cultivate.entity.CultivateNotifyItem;
import com.pcloud.readercenter.wechat.entity.WechatUser;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class CultivateNotifyDTO {
    @ApiModelProperty("消息类型（1-系统消息，2-通知消息，3-提醒消息，4-活动消息）")
    private Integer messageType;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("消息id")
    private Long messageId;

    @ApiModelProperty("个人号分类id")
    private Long classifyId;

    @ApiModelProperty("个人号wxId")
    private String wxId;

    @ApiModelProperty("bookId")
    private Long bookId;

    @ApiModelProperty("bookIds")
    private List<Long> bookIds;

    @ApiModelProperty("发送类型（1-指定用户，2-分类用户，3-按书籍查询，4-全局公告消息 5- 用户画像）")
    private Integer sendType;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date sendTime;

    @ApiModelProperty("发送内容")
    private List<CultivateNotifyItem> cultivateNotifyItems;

    @ApiModelProperty("跳转选择的应用作品")
    private List<CultivateNotifyItem> jumpNotifyItems;


    @ApiModelProperty("用户id")
    private List<WechatUserDTO> wechatUserDTOS;

    @ApiModelProperty("出版社id")
    private Long agentId;

    @ApiModelProperty("城市编码")
    private String cityCode;

    @ApiModelProperty("注册开始时间")
    private String  startTime;

    @ApiModelProperty("注册结束时间")
    private String endTime;

    @ApiModelProperty("用户学龄段标签id")
    private List<Long> userGradeLabelIds;

    @ApiModelProperty("是否首页弹窗")
    private Integer showHome;

    @ApiModelProperty("首页推图")
    private String squareImg;

    @ApiModelProperty("用户id")
    private Long wechatUserId;

    @ApiModelProperty("微信用户信息")
    private WechatUser wechatUser;

    @ApiModelProperty("内容")
    private String content;

    private Integer  serveType;

}
