package com.pcloud.book.group.entity;

import com.pcloud.common.entity.BaseEntity;

import java.util.Date;
import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 自有码H5页面栏目资源详情(ResourcePageItem)实体类
 *
 * @author makejava
 * @since 2021-03-26 15:26:22
 */
@Data
public class ResourcePageItem extends BaseEntity {
    private static final long serialVersionUID = -73454516097004755L;
    /**
    * 资源页id
    */
    private Long resourcePageId;
    /**
    * 资源栏目id
    */
    private Long resourcePageColumnId;
    /**
    * 资源id
    */
    private Long serveId;
    /**
    * 资源类型
    */
    private String serveType;
    /**
    * 链接url
    */
    private String linkUrl;
    /**
     * 资源类型
     */
    private String typeCode;
    /**
     * 排序值
     */
    private Integer seqNum;
    /**
     * 是否展示
     */
    private Boolean isShow;
    /**
     * 二维码引导关注文案
     */
    private String guideContent;
    /**
     * 二维码logo链接
     */
    private String logoUrl;
    /**
     * 创建人
     */
    private Long createUser;
    /**
     * 二维码来源
     */
    private Integer qrcodeSource;
    /**
     * 二维码展示方式（1平铺2弹窗）
     */
    private Integer qrcodeShowType;
    /**
     * 二维码公众号id
     */
    private Long accountSettingId;

    @ApiModelProperty("自定义大图")
    private String selfBigPic;

    @ApiModelProperty("简介")
    private String selfSmallPic;

    @ApiModelProperty("自定义标题")
    private String selfServeName;
}
