package com.pcloud.book.group.entity;

import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 自有码H5页面导航(ResourcePageNavigation)实体类
 *
 * @author makejava
 * @since 2021-08-16 10:43:21
 */
@Data
public class ResourcePageNavigation extends BaseEntity {
    private static final long serialVersionUID = 211236647765087489L;
    /**
    * 资源页id
    */
    private Long resourcePageId;
    /**
    * 类型（1本书配套2书友社区3自定义）
    */
    private Integer navigationType;
    /**
    * 导航名称
    */
    private String navigationName;
    /**
    * 图标
    */
    private String navigationIcon;
    /**
    * 排序值
    */
    private Integer navigationSeq;
    /**
    * 创建人
    */
    private Long createUser;

    /**
     * 服务id
     */
    private Long serveId;

    /**
     * 服务类型
     */
    private String serveType;

    /**
     * 资源类型
     */
    private String typeCode;

    /**
     * 链接地址
     */
    private String linkUrl;

    /**
     * 是否隐藏
     */
    private Integer isHide;



    @ApiModelProperty("应用或作品图片")
    private String servePic;

    @ApiModelProperty("应用或作品名称")
    private String serveName;

    @ApiModelProperty("应用或作品类型名称")
    private String typeName;

    @ApiModelProperty("是否第三方链接")
    private Boolean hasThirdLink;

    @ApiModelProperty("跳转结果链接")
    private String resultUrl;


    @ApiModelProperty("是否配置了公众号工具")
    private Boolean hasOfficialAccountsTool;

}
