package com.pcloud.book.group.facade.impl;

import com.pcloud.book.group.entity.WeworkTeacherFriendRecord;
import com.pcloud.book.group.biz.WeworkTeacherFriendRecordBiz;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import io.swagger.annotations.ApiOperation;

/**
 * 点击加老师好友记录表(WeworkTeacherFriendRecord)表控制层
 *
 * @author makejava
 * @since 2020-12-25 20:01:43
 */
@RestController("weworkTeacherFriendRecordFacade")
@RequestMapping("weworkTeacherFriendRecord")
public class WeworkTeacherFriendRecordFacade {
    
    @Autowired
    private WeworkTeacherFriendRecordBiz weworkTeacherFriendRecordBiz;

    
    @ApiOperation("通过主键查询单条数据")
    @GetMapping("getById")
    public ResponseDto<?> getById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(weworkTeacherFriendRecordBiz.getById(id));
    }
    
    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getList(@RequestHeader("token") String token, 
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage, 
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage) 
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(weworkTeacherFriendRecordBiz.getList(currentPage, numPerPage));
    }
    
    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert(@CookieValue("userInfo") String userInfo, @RequestBody WeworkTeacherFriendRecord weworkTeacherFriendRecord)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        weworkTeacherFriendRecord.setWechatUserId(wechatUserId);
        return new ResponseDto<>(weworkTeacherFriendRecordBiz.insert(weworkTeacherFriendRecord));
    }
    
    @ApiOperation("更新")
    @PostMapping("update")
    public ResponseDto<?> update(@RequestHeader("token") String token,@RequestBody WeworkTeacherFriendRecord weworkTeacherFriendRecord) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        weworkTeacherFriendRecordBiz.update(weworkTeacherFriendRecord);
        return new ResponseDto<>();
    }
    
    @ApiOperation("删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        if (null == id) {
            throw BookBizException.PARAM_DELETION;
        }
        weworkTeacherFriendRecordBiz.deleteById(id);
        return new ResponseDto<>();
    }

}
