package com.pcloud.book.personalstage.dao;

import com.pcloud.book.personalstage.dto.PersonalStageDTO;
import com.pcloud.book.personalstage.entity.PersonalStage;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

public interface PersonalStageDao extends BaseDao<PersonalStage> {

    void updateSeqNum(Long id, Integer seqNum);

    Integer getMaxSeqNum();

    Integer getCountByRobotClassifyId(Long robotClassifyId);

    PersonalStage getFirstStage(Long robotClassifyId);

    List<PersonalStageDTO> getPersonalStageList(Long robotClassifyId);

    List<Long> getPaperIdListByRobotClassify(Long robotClassifyId);
}