package com.pcloud.book.push.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel("个人号群发")
@Data
public class SelfPush extends BaseEntity{

    @ApiModelProperty("群发小号id")
    private String altId;

    @ApiModelProperty("小号名称")
    private String altName;

    private String altTypeName;

    @ApiModelProperty("创建人")
    private Long createUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改人")
    private Long updateUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("立即发送")
    private Boolean sendNow;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("开始时间")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("结束时间")
    private Date endTime;

    @ApiModelProperty("推送时间类型（1:每天发送 2:每周发送）")
    private Integer pushType;

    @ApiModelProperty("周几")
    private String weekDays;

    @ApiModelProperty("计划发送时间（不带日期）")
    private String pushSendTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("发送时间")
    private Date sendTime;

    @ApiModelProperty("bookGroupId")
    private Long bookGroupId;

    @ApiModelProperty("是否发送所有好友")
    private Boolean sendAll;

    @ApiModelProperty("个人号发送项集合")
    private List<SelfPushItem> pushItems;

    @ApiModelProperty("个人号类型（1微信2QQ）")
    private Integer altType;

    @ApiModelProperty("发送状态（0发送中1发送成功2发送失败）")
    private Integer pushStatus;
}