package com.pcloud.book.rightsSetting.biz.impl;

import com.pcloud.book.rightsSetting.biz.RightsSettingBannerBiz;
import com.pcloud.book.rightsSetting.dao.RightsSettingBannerDao;
import com.pcloud.book.rightsSetting.entity.RightsSettingBanner;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 权益banner(RightsSettingBanner)表服务实现类
 *
 * @author makejava
 * @since 2021-03-16 16:17:58
 */
@Service("rightsSettingBannerBiz")
public class RightsSettingBannerBizImpl implements RightsSettingBannerBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(RightsSettingBannerBizImpl.class);

    @Autowired
    private RightsSettingBannerDao rightsSettingBannerDao;

    @Override
    @ParamLog("通过ID查询单条数据")
    public RightsSettingBanner getById(Long id) {
        return rightsSettingBannerDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = rightsSettingBannerDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)) {
            return pageBeanNew;
        }
        // 加载其它数据

        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Long insert(RightsSettingBanner rightsSettingBanner) {
        rightsSettingBannerDao.insert(rightsSettingBanner);
        return rightsSettingBanner.getId();
    }

    @Override
    @ParamLog("修改")
    public void update(RightsSettingBanner rightsSettingBanner) {
        if (rightsSettingBanner == null || !NumberUtil.isNumber(rightsSettingBanner.getId())) {
            throw BizException.PARAM_IS_NULL;
        }
        rightsSettingBannerDao.update(rightsSettingBanner);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        rightsSettingBannerDao.deleteById(id);
    }

    @Override
    public void batchInsert(List<RightsSettingBanner> rightsSettingBanners) {
        if (ListUtils.isEmpty(rightsSettingBanners)) {
            return;
        }
        rightsSettingBannerDao.insert(rightsSettingBanners);
    }

    @Override
    public void deleteByRightsSettingId(Long rightsSettingId) {
        rightsSettingBannerDao.deleteByRightsSettingId(rightsSettingId);
    }

    @Override
    public List<RightsSettingBanner> getByRightsSettingId(Long rightsSettingId) {
        return rightsSettingBannerDao.getByRightsSettingId(rightsSettingId);
    }
}