package com.pcloud.book.book.biz;

import com.pcloud.book.book.dto.BookFundDto;
import com.pcloud.book.book.dto.BookFundInfoDto;
import com.pcloud.book.book.entity.BookFund;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageParam;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @描述：书刊基金业务层
 * @作者：lihao
 * @创建时间：2017年7月19日,下午3:14:10 @版本：1.0
 */
public interface BookFundBiz {

	/**
	 * @Title: create
	 * @Description:创建书刊基金状态
	 * @param bookFund
	 *            书刊基金实体
	 * @return: void
	 * @author: lihao
	 * @date: 2017年7月19日 下午5:29:14
	 */
	void create(BookFund bookFund);

	/**
	 * @Title: create
	 * @Description:创建书刊基金状态
	 * @param bookFund
	 *            书刊基金实体
	 * @return: void
	 * @author: lihao
	 * @date: 2017年7月19日 下午5:29:14
	 */
	void update(BookFund bookFund);

	/**
	 * @Title: getByBookId
	 * @Description:根据BookId获取基金状态
	 * @param bookId
	 *            图书标识
	 * @return: List<BookFundDto>
	 * @author: lihao
	 * @date: 2017年7月19日 下午5:29:04
	 */
	List<BookFundDto> getByBookId(Long bookId);

	/**
	 * @Title: isFundOccupy
	 * @Description:判断书刊某时间是否被买断
	 * @param bookId
	 *            图书标识
	 * @param date
	 *            时间
	 * @return: Boolean
	 * @author: lihao
	 * @date: 2017年7月21日 下午1:07:08
	 */
	Boolean isFundOccupy(Long bookId, String date);

	/**
	 * @Title: getFundList4Adviser
	 * @Description:编辑端获取基金买断信息
	 * @param bookId
	 *            图书标识
	 * @return: Map<String,Object>
	 * @author: lihao
	 * @date: 2017年7月21日 下午1:10:20
	 */
	Map<String, Object> getFundList4Adviser(Long bookId);

	/**
	 * @Title: getBookFundMoney
	 * @Description:批量获取书刊基金总额
	 * @param bookIds
	 *            图书标识列表
	 * @return: Map<Long,BigDecimal>
	 * @author: lihao
	 * @date: 2017年7月21日 下午1:05:01
	 */
	Map<Long, BigDecimal> getBookFundMoney(List<Long> bookIds);

	/**
	 * 获取图书在基金支持的基金名称
	 * 
	 * @param bookId
	 *            图书标识
	 * @param useDate
	 *            日期
	 * @return
	 */
	String getUseFundName(Long bookId, String useDate);

	/**
	 * 获取图书基金状态
	 * 
	 * @param pageParam
	 *            分页参数传递工具类
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	PageBean listByBookId(PageParam pageParam, Long bookId);

	/**
	 * 正在基金支持的图书
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @return
	 */
	Long getHaveFundBook(List<Long> bookIds);

	/**
	 * 获取书刊基金状态
	 * 
	 * @param bookFundId
	 *            书刊基金标识
	 * @return
	 */
	BookFundDto getByBookFundId(Long bookFundId);

	/**
	 * 删除书刊基金
	 * 
	 * @param bookFundId
	 *            书刊基金标识
	 */
	void deleteById(Long bookFundId);

	/**
	 * 正在基金支持的图书列表
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @return
	 */
	List<Long> listHaveFundBooks(List<Long> bookIds);

	/**
	 * 获取所有正在基金支持的图书列表
	 * 
	 * @return
	 */
	List<Long> listAllHaveFundBooks();

	/**
	 * 获取图书在基金支持的基金信息
	 *
	 * @param bookId
	 *            图书标识
	 * @param useDate
	 *            日期
	 * @return
	 */
	BookFundInfoDto getUseFundInfo(Long bookId, String useDate);
}
