/**
 * 
 */
package com.pcloud.book.book.facade.impl;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.codehaus.jackson.JsonParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.pcloud.book.book.biz.BookTypeBiz;
import com.pcloud.book.book.dto.BookTypeDto;
import com.pcloud.book.book.facade.BookTypeFacade;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;

/**
 * @描述：
 * 
 * @作者：songx
 * @创建时间：2017年1月3日,下午3:14:10 @版本：1.0
 */
@RequestMapping("/bookType")
@RestController("bookTypeFacade")
@Produces({ ContentType.APPLICATION_JSON_UTF_8 })
@Consumes({ MediaType.APPLICATION_JSON })
public class BookTypeFacadeImpl implements BookTypeFacade {

	@Autowired
	private BookTypeBiz bookTypeBiz;

	/**
	 * 获取书籍类型列表
	 */
	@Override
	@RequestMapping(value = "list", method = RequestMethod.GET)
	public ResponseDto<List<BookTypeDto>> getList(@RequestHeader("token") String token)
			throws BizException, PermissionException, JsonParseException {
		SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		List<BookTypeDto> bookTypeDtos = bookTypeBiz.getList();
		return new ResponseDto<>(bookTypeDtos == null ? new ArrayList<>() : bookTypeDtos);
	}

	/**
	 * 微信端获取书籍类型列表
	 */
	@Override
	@RequestMapping(value = "list4Wechat", method = RequestMethod.GET)
	public ResponseDto<List<BookTypeDto>> getList4Wechat(@CookieValue("userInfo") String userInfo)
			throws BizException, PermissionException, JsonParseException {
		Cookie.getId(userInfo, Cookie._PARTY_ID);
		List<BookTypeDto> bookTypeDtos = bookTypeBiz.getList();
		return new ResponseDto<>(bookTypeDtos == null ? new ArrayList<>() : bookTypeDtos);
	}

	/**
	 * 图书和期刊占比
	 */
	@Override
	@RequestMapping(value = "getPercent4Type", method = RequestMethod.GET)
	public ResponseDto<List<BookTypeDto>> getPercent4Type(@RequestHeader("token") String token)
			throws BizException, PermissionException, JsonParseException {
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		List<BookTypeDto> bookTypeDtos = bookTypeBiz.getPercent4Type(adviserId);
		return new ResponseDto<>(bookTypeDtos == null ? new ArrayList<BookTypeDto>() : bookTypeDtos);
	}

}
