/**
 * 
 */
package com.pcloud.book.book.service.impl;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.pcloud.book.book.biz.BookAdviserBiz;
import com.pcloud.book.book.dto.BookAdviserDto;
import com.pcloud.book.book.entity.BookAdviser;
import com.pcloud.book.book.service.BookAdviserService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;

/**
 * @描述：编辑推广书籍接口类实现类
 * @作者：songx
 * @创建时间：2017年1月4日,下午7:59:13 @版本：1.0
 */
@RestController("bookAdviserService")
@RequestMapping("bookAdviserService")
public class BookAdviserServiceImpl implements BookAdviserService {

	@Autowired
	private BookAdviserBiz bookAdviserBiz;

	/**
	 * 获取编辑的推广书籍总数
	 */
	@Override
	@RequestMapping(value = "/getCountByAdvisers", method = RequestMethod.POST)
	public ResponseEntity<ResponseDto<Map<Long, BookAdviserDto>>> getCountByAdvisers(
			@RequestBody(required = false) List<Long> adviserIds) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getCountByAdvisers(adviserIds));
	}

	/**
	 * 根据ISBN获取书籍信息
	 */
	@Override
	@RequestMapping(value = "/getByIsbn", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<BookAdviserDto>> getByIsbn(
			@RequestParam(value = "isbn", required = false) String isbn,
			@RequestParam(value = "channelId", required = false) Long channelId) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getByIsbn(isbn, channelId));
	}

	/**
	 * 根据图书信息获取主编辑ID
	 */
	@Override
	@RequestMapping(value = "/getMainAdviserId", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<Long>> getMainAdviserId(
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "channelId", required = false) Long channelId) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.getMainAdviserId(bookId, channelId));
	}

	/**
	 * 创建默认图书与编辑的关系
	 */
	@Override
	@RequestMapping(value = "/createDefaultBook", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<Long>> createDefaultBook(
			@RequestParam(value = "adviserId", required = false) Long adviserId) throws BizException {
		return ResponseHandleUtil.toResponse(bookAdviserBiz.createDefaultBook(null, adviserId));
	}

	/**
	 * 设置图书使用模板
	 */
	@Override
	@RequestMapping(value = "/setBookTemplet", method = RequestMethod.POST)
	public void setBookTemplet(@RequestBody BookAdviser bookAdviser) throws BizException {
		bookAdviserBiz.setBookTemplet(bookAdviser);
	}

}
