/**
 *
 */
package com.pcloud.book.consumer.channel;


import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.channelcenter.qrcode.dto.DefaultTempletQrcode;
import com.pcloud.channelcenter.qrcode.service.QrcodeSceneService;
import com.pcloud.channelcenter.qrcode.vo.BookAssocLastQrAskVO;
import com.pcloud.channelcenter.qrcode.vo.BookAssocLastQrVO;
import com.pcloud.channelcenter.qrcode.vo.BookAssocQRcountRequestVO;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：二维码中间件
 * @作者：songx
 * @创建时间：2016年12月14日,下午5:36:04 @版本：1.0
 */
@Component("qrcodeSceneConsr")
public class QrcodeSceneConsr {

	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(QrcodeSceneConsr.class);

	@Autowired
	private QrcodeSceneService qrcodeSceneService;

	/**
	 * 删除书籍关联的二维码
	 */
	public void deleteBook(Long bookId, Long channelId, Long adviserId) throws BizException {
		LOGGER.info("【二维码-渠道(消)】删除书籍关联的二维码,<PARAM>.[bookId]=" + bookId+"channelId="+channelId+"adviserId="+adviserId);
		if (bookId == null) {
			throw new BookBizException(BookBizException.PARAM_IS_NULL, "书籍标识不能为空~!");
		}
		try {
			qrcodeSceneService.deleteBook(bookId, channelId, adviserId);
			LOGGER.info("【二维码-渠道(消)】删除书籍关联的二维码关联关系,<END>");
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】删除书籍关联的二维码关联关系,<ERROR>.[qrcodeSceneService.deleteBook]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】删除书籍关联的二维码关联关系,<ERROR>.[qrcodeSceneService.deleteBook]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, "批量删除书籍关联的二维码关联关系失败~!");
		}
	}

	/**
	 * 获取书籍对应二维码关系
	 */
	public Map<String, Object> getQr4Book(Long bookId) throws BizException {
		LOGGER.info("【二维码-渠道(消)】 获取书籍对应二维码关系,<PARAM>.[bookId]=" + bookId);
		Map<String, Object> result = null;
		try {
			ResponseEntity<ResponseDto<Map<String, Object>>> qr4Book = qrcodeSceneService.getQr4Book(bookId);
			result = ResponseHandleUtil.parseMap(qr4Book, String.class, Object.class);
			LOGGER.info("【二维码-渠道(消)】 获取书籍对应二维码关系,<END>");
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】 获取书籍对应二维码关系,<ERROR>.[qrcodeSceneService.getQr4Book]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】 获取书籍对应二维码关系,<ERROR>.[qrcodeSceneService.getQr4Book]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, "获取书籍对应二维码关系失败~!");
		}
		return result;
	}

	/**
	 * 删除编辑二维码关联关系
	 */
	public void deleteAdviserBookQrRelation(Long adviserId, Long bookId) throws BizException {
		LOGGER.info("【二维码-渠道(消)】删除编辑二维码关联关系,<PARAM>.[adviserId]=" + adviserId + ",[bookId]=" + bookId);
		if (bookId == null) {
			LOGGER.error("【二维码-渠道(消)】删除编辑二维码关联关系,<PARAM=NULL>");
			throw new BookBizException(BookBizException.PARAM_IS_NULL, "编辑标识和书籍标识不能为空~!");
		}

		try {
			qrcodeSceneService.deleteAdviserBookQrRelation(adviserId, bookId);
			LOGGER.info("【二维码-渠道(消)】删除编辑二维码关联关系,<END>");
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】删除编辑二维码关联关系,<ERROR>.[qrcodeSceneService.deleteBook]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】删除编辑二维码关联关系,<ERROR>.[qrcodeSceneService.deleteBook]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, "删除编辑二维码关联关系失败~!");
		}
	}

	/**
	 * 获取书籍二维码个数
	 */
	public Map<String, Long> listBookQrCount(List<Long> bookIds, List<Long> channelIds, Long adviserId)
			throws BizException {
		LOGGER.info("【二维码-渠道(消)】获取书籍二维码个数,<START>.[bookIds]=" + bookIds + ",[channelIds]=" + channelIds
				+ ",[adviserId]=" + adviserId);
		Map<String, Long> bookQrCount = new HashMap<>();
		if (ListUtils.isEmpty(bookIds) || ListUtils.isEmpty(channelIds) || adviserId == null) {
			return bookQrCount;
		}
		try {
			Map<String, Object> idsMap = new HashMap<>();
			idsMap.put("bookIds", bookIds);
			idsMap.put("channelIds", channelIds);
			ResponseEntity<ResponseDto<Map<String, Long>>> listBookQrCount = qrcodeSceneService.listBookQrCount(idsMap,
					adviserId);
			bookQrCount = ResponseHandleUtil.parseMap(listBookQrCount, String.class, Long.class);
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】获取书籍二维码个数,<ERROR>.[qrcodeSceneService.deleteBook]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】获取书籍二维码个数,<ERROR>.:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, "获取书籍二维码个数失败~!");
		}
		LOGGER.info("【二维码-渠道(消)】获取书籍二维码个数,<END>");
		return bookQrCount;
	}

	/**
	 * 默认生成二维码以及对应数据
	 */
	public Long createDefualtByTemplet(Long templetId, Long channelId, Long adviserId, Long agentId, Long bookId,
									   Long sceneId) throws BizException {
		LOGGER.info("【二维码-渠道(消)】默认生成二维码以及对应数据,<START>.[templetId]=" + templetId + ",[channelId]=" + channelId
				+ ",[adviserId]=" + adviserId + ",[agentId]=" + agentId + ",[bookId]=" + bookId + ",[sceneId]="
				+ sceneId);
		try {
			DefaultTempletQrcode defaultTempletQrcode = new DefaultTempletQrcode();
			defaultTempletQrcode.setTempletId(templetId);
			defaultTempletQrcode.setAgentId(agentId);
			defaultTempletQrcode.setBookId(bookId);
			defaultTempletQrcode.setChannelId(channelId);
			defaultTempletQrcode.setSceneId(sceneId);
			defaultTempletQrcode.setAdviserId(adviserId);
			LOGGER.info("【二维码-渠道(消)】默认生成二维码以及对应数据,<START>.defaultTempletQrcode=" + defaultTempletQrcode);
			ResponseEntity<ResponseDto<Long>> createDefualtByTemplet = qrcodeSceneService
					.createDefualtByTemplet(defaultTempletQrcode);
			sceneId = ResponseHandleUtil.parseResponse(createDefualtByTemplet, Long.class);
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】默认生成二维码以及对应数据[qrcodeSceneService.createDefualtByTemplet]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】默认生成二维码以及对应数据,<ERROR>.[create]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, "默认生成二维码以及对应数据失败~!");
		}
		LOGGER.info("【二维码-渠道(消)】默认生成二维码以及对应数据,<END>");
		return sceneId;
	}

	/**
	 * 图书关联二维码
	 */
	public Long relationQr(Long bookId, Long sceneId, Long adviserId) throws BizException {
		LOGGER.info(
				"【二维码-渠道(消)】 图书关联二维码,<START>.[bookId]=" + bookId + ",[sceneId]=" + sceneId + "adviserId=" + adviserId);
		try {
			qrcodeSceneService.relationQr(bookId, sceneId, adviserId);
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】 图书关联二维码:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】 图书关联二维码,<ERROR>.[create]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, "图书关联二维码失败~!");
		}
		LOGGER.info("【二维码-渠道(消)】 图书关联二维码,<END>");
		return sceneId;
	}

	/**
	 * 根据图书删除二维码
	 */
	public void deleteByBook(Long bookId, Long channelId, Long adviserId) throws BizException {
		LOGGER.info("【二维码-渠道(消)】根据图书删除二维码,<START>.[bookId]=" + bookId + ",[channelId]=" + channelId + "[adviserId]="
				+ adviserId);
		if (bookId == null || channelId == null) {
			return;
		}
		try {
			qrcodeSceneService.deleteByBook(bookId, channelId, adviserId);
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】 根据图书删除二维码[qrcodeSceneService.deleteByBook]失败:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】 根据图书删除二维码[qrcodeSceneService.deleteByBook],<ERROR>.[create]:" + e.getMessage(),
					e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, " 根据图书删除二维码失败~!");
		}
		LOGGER.info("【二维码-渠道(消)】 根据图书删除二维码,<END>");
	}

	/**
	 * 根据图书恢复二维码
	 */
	public void recoverByBook(Long bookId, Long channelId, Long adviserId) throws BizException {
		LOGGER.info("【二维码-渠道(消)】根据图书恢复二维码,<START>.[bookId]=" + bookId + ",[channelId]=" + channelId + "[adviserId]="
				+ adviserId);
		if (bookId == null || channelId == null) {
			return;
		}
		try {
			qrcodeSceneService.recoverByBook(bookId, channelId, adviserId);
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】 根据图书恢复二维码[qrcodeSceneService.recoverByBook]失败:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】 根据图书恢复二维码[qrcodeSceneService.recoverByBook],<ERROR>.[create]:" + e.getMessage(),
					e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, " 根据图书恢复二维码失败~!");
		}
		LOGGER.info("【二维码-渠道(消)】 根据图书恢复二维码,<END>");
	}

	/**
	 * 获取图书待审核二维码
	 */
	public Map<Long, Long> getCountMapByBookIds(List<Long> bookIds) throws BizException {
		LOGGER.info("【二维码-渠道(消)】获取图书待审核二维码,<START>.[bookIds]=" + bookIds);
		if (ListUtils.isEmpty(bookIds)) {
			return null;
		}
		Map<Long, Long> result = null;
		try {
			result = ResponseHandleUtil.parseMapResponse(qrcodeSceneService.getCountMapByBookIds(bookIds),Long.class,Long.class);
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】 获取图书待审核二维码[qrcodeSceneService.getCountMapByBookIds]失败:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】 获取图书待审核二维码[qrcodeSceneService.getCountMapByBookIds],<ERROR>.[create]:" + e.getMessage(),
					e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, " 获取图书待审核二维码失败~!");
		}
		LOGGER.info("【二维码-渠道(消)】 获取图书待审核二维码,<END>");
		return result;
	}

	/**
	 * 获取图书最近关联二维码信息
	 */
	public Map<String, BookAssocLastQrVO> getLastQrInfoByBookIds(List<BookAssocLastQrAskVO> bookAssocLastQrAskVOs) throws BizException {
		LOGGER.info("【二维码-渠道(消)】获取图书最近关联二维码信息,<START>.[bookAssocLastQrAskVOs]=" + bookAssocLastQrAskVOs);
		if (ListUtils.isEmpty(bookAssocLastQrAskVOs)) {
			return null;
		}
		Map<String, BookAssocLastQrVO> result = null;
		try {
			result = ResponseHandleUtil.parseMapResponse(qrcodeSceneService.getLastQrInfoByBookIds(bookAssocLastQrAskVOs),String.class,BookAssocLastQrVO.class);
		} catch (BizException e) {
			LOGGER.warn("【二维码-渠道(消)】 获取图书最近关联二维码信息[qrcodeSceneService.getLastQrInfoByBookIds]失败:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【二维码-渠道(消)】 获取图书最近关联二维码信息[qrcodeSceneService.getLastQrInfoByBookIds],<ERROR>.[create]:" + e.getMessage(),
					e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, " 获取图书最近关联二维码信息失败~!");
		}
		LOGGER.info("【二维码-渠道(消)】 获取图书最近关联二维码信息,<END>");
		return result;
	}

	@ParamLog(description = "获取图书关联二维码个数")
	public Integer getBookQRCountByMap(Long adviserId,Long channelId,Long bookId)throws BizException{
		Integer count = 0;
		BookAssocQRcountRequestVO bookAssocQRcountRequestVO = new BookAssocQRcountRequestVO();
		bookAssocQRcountRequestVO.setAdviserId(adviserId);
		bookAssocQRcountRequestVO.setBookId(bookId);
		bookAssocQRcountRequestVO.setChannelId(channelId);
		try {
			count = ResponseHandleUtil.parseResponse(qrcodeSceneService.getBookQRCountByMap(bookAssocQRcountRequestVO),Integer.class);
		} catch (BizException e) {
			LOGGER.error("【二维码-渠道(消)】 获取图书关联二维码个数[qrcodeSceneService.getBookQRCountByMap],<ERROR>.[create]:" + e.getMessage(),
					e);
			throw new BookBizException(BookBizException.INVOKE_CHANNEL_ERROR, " 获取图书关联二维码个数失败~!");
		}
		return count;
	}

	@ParamLog(description = "批量获取图书关联二维码个数")
	public Map<String,Long> getBookQRCountByMap(List<BookAssocQRcountRequestVO> bookAssocQRcountRequestVOS,String monthDate)throws BizException{
		Map<String,Long> countMap = null;
		try {
			countMap = ResponseHandleUtil.parseMapResponse(qrcodeSceneService.bookAssosQrcountList(bookAssocQRcountRequestVOS,monthDate),String.class,Long.class);
		} catch (BizException e) {
			LOGGER.error("【二维码-渠道(消)】 批量获取图书关联二维码个数[qrcodeSceneService.bookAssosQrcountList],<ERROR>.[create]:" + e.getMessage(),
					e);
		}
		return countMap;
	}

}
