package com.pcloud.book.consumer.trade;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.facade.tradecenter.dto.BookIncomeQueryVo;
import com.pcloud.facade.tradecenter.service.OrderFormService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Component("orderFormConsr")
public class OrderFormConsr {

    @Autowired
    private OrderFormService orderFormService;

    private static final Logger LOGGER = LoggerFactory.getLogger(OrderFormConsr.class);

    @ParamLog(description = "获取图书收益")
    public Map<String, BigDecimal> getBookIncome(List<BookIncomeQueryVo> bookIncomeQueryVos,String date)throws BizException {
        Map<String, BigDecimal> incomeMap = null;
        try {
            incomeMap = ResponseHandleUtil.parseMapResponse(orderFormService.getBookIncome(bookIncomeQueryVos,date),String.class,BigDecimal.class);
        } catch (Exception e) {
            LOGGER.error("[消TRADECENTER.orderFormService.getBookIncome]出现异常，信息为:"+e.getMessage(),e);
        }
        return incomeMap;
    }

}
