/**
 * 
 */
package com.pcloud.book.mq.topic;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;

import com.pcloud.book.mq.config.MQTopicConumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.book.biz.BookProductBiz;
import com.pcloud.common.exceptions.BizException;

/**
 * @描述：
 * 
 * @作者：songx
 * @创建时间：2017年7月5日,上午11:58:44 @版本：1.0
 */
@Component
@RabbitListener(queues = MQTopicConumer.DELETE_VIDEO)
public class DeleteVideoListener {

	/**
	 * 
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(DeleteVideoListener.class);

	@Autowired
	private BookProductBiz bookProductBiz;

	/**
	 * 接收录音删除消息
	 */
	@RabbitHandler
	public void process(Long videoId) throws BizException {
		if (videoId == null) return;
		try{
			// 清除录音
			bookProductBiz.clearSound(videoId);
		} catch (Exception e) {
			LOGGER.error("【录音删除】消费topic,JMS异常,<ERROR>:" + e.getMessage(), e);
			return;
		}
	}
}
