package com.pcloud.book.mq.topic;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;

import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.usercenter.common.enums.ResourceEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.appcenter.base.exception.AppBizException;
import com.pcloud.book.book.biz.BookAdviserBiz;
import com.pcloud.common.core.constant.SystemCode;
import com.pcloud.usercenter.party.common.entity.Party;

@Component("registerPartyListener")
@RabbitListener(queues = MQTopicConumer.REGISTER_PARTY)
public class RegisterPartyListener{
	@Autowired
	private BookAdviserBiz bookAdviserBiz;

	/**
	 * 用户注册Topic
	 */
	@ParamLog("用户注册topic")
	@RabbitHandler
	public void process(Party party) {
		if (party == null) {
			return;
		}
		if (SystemCode.adviser.code.equalsIgnoreCase(party.getPartyRole()) && ResourceEnum.APP.code.equals(party.getResourceId())) {
			bookAdviserBiz.createDefaultBook(party.getAgentId(), party.getId());
		}
	}
}
