package com.pcloud.book.reading.service;

import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.Map;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @描述：共读活动
 * @作者：zhuyajie
 * @创建时间：15:45 2020/1/15
 * @版本：1.0
 */

@FeignClient(value = "pcloud-service-book", qualifiers = "readingActivityServiceCloud", path = "book/v1.0/readingActivityService")
@Api(description = "共读活动内部服务")
public interface ReadingActivityService {

    @ApiOperation(value = "定时任务发邀请语", httpMethod = "POST")
    @PostMapping("/sendInviteMsg")
    public void sendInviteMsg(@RequestBody @ApiParam Map<String, Object> map);

    @ApiOperation(value = "定时任务发开场语", httpMethod = "POST")
    @PostMapping("/sendStartMsg")
    public void sendStartMsg(@RequestBody @ApiParam Map<String, Object> map);

    @ApiOperation(value = "定时任务发结束语", httpMethod = "POST")
    @PostMapping("/sendEndMsg")
    public void sendEndMsg(@RequestBody @ApiParam Map<String, Object> map);

    @ApiOperation(value = "定时任务发打卡每日提醒", httpMethod = "POST")
    @PostMapping("/sendClockRemind")
    public void sendClockRemind(@RequestBody @ApiParam Map<String, Object> map);

}
