package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.entity.AppletSubscribeRecord;
import com.pcloud.common.page.PageBeanNew;

/**
 * (AppletSubscribeRecord)表服务接口
 *
 * @author wubo
 * @since 2021-08-03 09:37:00
 */
public interface AppletSubscribeRecordBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    AppletSubscribeRecord getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param appletSubscribeRecord 实例对象
     * @return 主键
     */
    Long insert(AppletSubscribeRecord appletSubscribeRecord);

    /**
     * 修改数据
     *
     * @param appletSubscribeRecord 实例对象
     */
    void update(AppletSubscribeRecord appletSubscribeRecord);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    /**
     * 通过主键软删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void softDeleteById(Long id);
}