package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletSubscribeCountDao;
import com.pcloud.book.applet.entity.AppletSubscribeCount;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.Map;

/**
 * (AppletSubscribeCount)表数据库访问层
 *
 * @author wubo
 * @since 2021-08-03 09:37:45
 */
@Repository("appletSubscribeCountDaoImpl")
public class AppletSubscribeCountDaoImpl extends BaseDaoImpl<AppletSubscribeCount> implements AppletSubscribeCountDao {
    public int softDeleteById(Long id) {
        return getSessionTemplate().update(getStatement("softDeleteById"), id);

    }

    @Override
    public AppletSubscribeCount getByUserId(Long wechatUserId, Integer recordType) {
        Map<String, Object> params = new HashMap<>();
        params.put("wechatUserId", wechatUserId);
        params.put("recordType", recordType);
        return getSessionTemplate().selectOne(getStatement("getByUserId"), params);
    }

    @Override
    public void clearSubscribeCount(Long wechatUserId, Integer recordType) {
        Map<String, Object> params = new HashMap<>();
        params.put("wechatUserId", wechatUserId);
        params.put("recordType", recordType);
        getSessionTemplate().update(getStatement("clearSubscribeCount"), params);
    }
}