package com.pcloud.book.applet.entity;

import com.pcloud.book.rightsSetting.entity.BaseTempletClassify;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@ApiModel("小程序资讯")
public class AppletNews extends BaseTempletClassify {

    @ApiModelProperty("资讯")
    private String newsName;
    @ApiModelProperty("来源")
    private String source;
    @ApiModelProperty("栏目id")
    private Long newsClassifyId;
    @ApiModelProperty("专业标签ID")
    private Long proLabelId;
    @ApiModelProperty("深度标签ID")
    private Long depLabelId;
    @ApiModelProperty("目的标签ID")
    private Long purLabelId;
    @ApiModelProperty("文章版式（1多图文2单图文3纯图片4纯文本)")
    private Integer type;
    @ApiModelProperty("内容摘要")
    private String digest;
    @ApiModelProperty("预览图片1")
    private String pic1;
    @ApiModelProperty("预览图片2")
    private String pic2;
    @ApiModelProperty("预览图片3")
    private String pic3;
    @ApiModelProperty("文章内容")
    private String content;
    @ApiModelProperty("是否展示")
    private Boolean showState;
    @ApiModelProperty("第一级类型标识")
    private Long firstClassify;
    @ApiModelProperty("第二级类型标识")
    private Long secondClassify;
    @ApiModelProperty("年级标签id")
    private Long gradeLabelId;
    @ApiModelProperty("科目标签id")
    private Long subjectLabelId;
    @ApiModelProperty("权益分类id")
    private Long rightsClassifyId;
    @ApiModelProperty("跳转类型（1原文编辑2直接跳转）")
    private Integer jumpType;
    @ApiModelProperty("跳转地址")
    private String jumpUrl;
    @ApiModelProperty("跳转外链编号")
    private String urlNumber;
    @ApiModelProperty("自定义标识id")
    private Long customTagId;
    @ApiModelProperty("展示来源")
    private Integer showSource;
    @ApiModelProperty("展示第三方资源")
    private Integer showLink;
    @ApiModelProperty("名片id")
    private Long businessCardId;
    @ApiModelProperty("类型： 0默认   1指定名片")
    private Long businessCardType;
    @ApiModelProperty("类型： 0关   1开")
    private Long businessCardIsOpen;

    @ApiModelProperty("姓名")
    @NotNull(message = "姓名不能为空")
    private String name;

    @ApiModelProperty("头衔")
    @NotNull(message = "头衔不能为空")
    private String title;

    @ApiModelProperty("二维码")
    private String qrcode;

    @ApiModelProperty("头像")
    private String headPhoto;

    @ApiModelProperty("微信号")
    private String wechatNum;

    @ApiModelProperty("电话")
    @Length(min = 0,max = 11,message = "电话号码最多11位")
    private String phone;

    @ApiModelProperty("创建人")
    private Long creator;

    @ApiModelProperty("修改人")
    private Long updator;

    @ApiModelProperty("城市编码")
    private String cityCode;

    @ApiModelProperty("城市")
    private String city;

    @ApiModelProperty("出版社id")
    private Long agentId;

    @ApiModelProperty("选取的服务")
    List<AppletNewsServe> appletNewsServeList;

    @ApiModelProperty("咨询类别")
    List<AppletNewsCategory> appletNewsCategoryList;

    @ApiModelProperty("第三方资源")
    List<AppletThirdResourcesRelation> thirdResourcesRelations;

    @ApiModelProperty("划线价")
    private String crossedPrice;

    @ApiModelProperty("评估价")
    private String appraisalPrice;

    @ApiModelProperty("评估价类型  0 文字  1 图片")
    private Integer appraisalType;

    @ApiModelProperty("评估价图片")
    private String appraisalImg;
}
