package com.pcloud.book.applet.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * (AppletSubscribeRecord)实体类
 *
 * @author wubo
 * @since 2021-08-09 10:51:15
 */
@Data
public class AppletSubscribeRecord extends BaseEntity {

    private static final long serialVersionUID = 190586377697572581L;

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("用户id")
    private Long wechatUserId;

    @ApiModelProperty("记录类型 1 消息未读提醒  2 主人召回提醒")
    private Integer recordType;

    @ApiModelProperty("记录类型  1 小程序服务消息+1  2 小程序服务消息-1 ")
    private Integer countType;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

}