package com.pcloud.book.book.biz;

import com.pcloud.book.book.vo.request.BookQrcodeWxworkRequestVO;
import com.pcloud.book.book.vo.response.BookQrcodeWxworkResponseVO;
import com.pcloud.book.group.dto.BookGroupServeCountDTO;
import com.pcloud.book.group.dto.ResourceOnBookDTO;
import com.pcloud.book.group.dto.WxworkQrcodeDTO;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

/**
 * 二维码配置企业微信
 * @author：zhuyajie
 * @date：2020/12/22 18:24
 *  * @param null
 */
public interface BookQrcodeWxworkBiz {


    /**
     * 二维码设置关联企业微信码
     * @author：zhuyajie
     * @date：2020/12/23 10:40
     *  * @param null
     */
    void setWxworkQrcode(BookQrcodeWxworkRequestVO bookQrcodeWxworkRequestVO);

    /**
     * 查配置的企业微信码id
     * @author：zhuyajie
     * @date：2020/12/23 11:09
     *  * @param null
     */
    Long getWxworkQrcodeIdBySceneOrBookGroup(Long sceneId, Long bookGroupId, Integer wxworkQrcodeType);

    /**
     * 查配置的企业微信码及信息
     * @author：zhuyajie
     * @date：2020/12/23 11:21
     *  * @param null
     */
    BookQrcodeWxworkResponseVO getWxworkQrcodeInfoBySceneOrBookGroup(Long sceneId, Long bookGroupId, Integer wxworkQrcodeType);

    /**
     * 根据书刊查RAYS码配置的企业微信
     * @author：zhuyajie
     * @date：2020/12/23 16:41
     *  * @param null
     */
    List<BookQrcodeWxworkResponseVO> getWxworkQrcodeInfoByBook4Rays(Long bookId, Long channelId, Long adviserId, Integer wxworkQrcodeType);

    /**
     * 查本书外已被勾选的群id
     * @author：zhuyajie
     * @date：2021/1/27 15:40
     *  * @param null
     */
    List<Long> getWxworkGroupQrcodeIdsExceptBook(Long sceneId, Long bookGroupId);

    /**
     * 获取二维码配置的企业微信
     */
    Map<Long, BookGroupServeCountDTO> mapWxWorkServeCount4SceneIds(List<Long> sceneIds, Integer bookQrcodeType);

    /**
     * 获取二维码配置的企业微信
     */
    Map<String, BookGroupServeCountDTO> mapWxWorkServeCount4BookIds(List<Long> adviserIds, List<Long> bookIds, List<Long> channelIds, String strSceneIds);

    /**
     *erp获取二维码下面配置了企业微信的二维码
     */
    List<Long> getHasWxWorkCode(List<Long> sceneIds);

    /**
     * @Description  公众号二维码配置的企微活码
     * @Author zhuyajie
     * @Date 16:39 2021/12/10
     **/
    List<WxworkQrcodeDTO> getWxworkQrcodesBySceneId4Official(Long sceneId);


    /**
     * 企微群码上书列表
     * @author：zhuyajie
     * @date：2022/1/10
     *  * @param null
     */
    PageBeanNew<ResourceOnBookDTO> listWxworkGroupOnBook(Integer currentPage, Integer numPerPage, Long groupId);

    /**
     * @Description  导出-企微群码上书列表
     * @Author zhuyajie
     * @Date 19:42 2021/12/14
     **/
    void exportWxworkGroupOnBook(Long groupId,Long partyId);
}
