package com.pcloud.book.book.dao.impl;

import com.pcloud.book.book.entity.BookUserBrowseRecord;
import com.pcloud.book.book.dao.BookUserBrowseRecordDao;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 书籍用户关联表(BookUserBrowseRecord)表数据库访问层
 *
 * @author wubo
 * @since 2021-12-03 10:40:19
 */
@Repository("bookUserBrowseRecordDaoImpl")
public class BookUserBrowseRecordDaoImpl extends BaseDaoImpl<BookUserBrowseRecord> implements BookUserBrowseRecordDao {
    public int softDeleteById(Long bookId) {
        return getSessionTemplate().update(getStatement("softDeleteById"), bookId);

    }

    @Override
    public List<Long> getUserIdsByBookId(List<Long> bookIds) {
        return getSessionTemplate().selectList(getStatement("getUserIdsByBookId"), bookIds);
    }
}
