package com.pcloud.book.book.entity;

import com.pcloud.common.entity.BaseEntity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 二维码配置企业微信码(BookQrcodeWxwork)实体类
 *
 * @author makejava
 * @since 2020-12-22 17:22:19
 */
@Data
public class BookQrcodeWxwork extends BaseEntity {
    private static final long serialVersionUID = 528640838870071638L;
    /**
    * 主键
    */
    private Long id;
    /**
    * 书刊id
    */
    private Long bookId;
    /**
    * 渠道id
    */
    private Long channelId;
    /**
    * 编辑id
    */
    private Long adviserId;
    /**
    * 书刊二维码类型（1公众号2RAYS码）
    */
    private Integer bookQrcodeType;
    /**
    * 公众号sceneid/RAYS码bookgroupid
    */
    private Long bookQrcodeId;
    /**
    * 企业微信活码id
    */
    private Long wxworkQrcodeId;
    /**
     * 企业微信二维码类型（1sop活码2群活码）
     */
    private Integer wxworkQrcodeType;

    @ApiModelProperty("引导语")
    private String guide;

}