/**
 *
 */
package com.pcloud.book.book.facade;

import com.pcloud.book.base.dto.CountDto;
import com.pcloud.book.book.dto.BookAppDto;
import com.pcloud.book.book.entity.BookApp;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.codehaus.jackson.JsonParseException;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @描述：
 * 
 * @作者：songx
 * @创建时间：2016年12月23日,下午4:06:04 @版本：1.0
 */
@Api(description = "书籍应用关系管理外部服务")
public interface BookAppFacade {

	/**
	 * 添加书籍和应用关联关系
	 *
	 * @param token
	 * @param bookApp
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "添加书籍和应用关联关系", httpMethod = "POST")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
			@ApiImplicitParam(name = "bookApp", value = "书籍应用关系实体", dataType = "BookApp", paramType = "body") })
	@RequestMapping(value = "create", method = RequestMethod.POST)
	public ResponseDto<BookAppDto> create(@RequestHeader("token") String token, @RequestBody BookApp bookApp)
			throws BizException, PermissionException, JsonParseException;

	/**
	 * 微信端添加书籍和应用关联关系
	 *
	 * @param userInfo
	 * @param bookApp
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "微信端添加书籍和应用关联关系", httpMethod = "POST")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "string", paramType = "header"),
			@ApiImplicitParam(name = "bookApp", value = "书籍应用关系实体", dataType = "BookApp", paramType = "body") })
	@RequestMapping(value = "create4Wechat", method = RequestMethod.POST)
	public ResponseDto<BookAppDto> create4Wechat(@CookieValue("userInfo") String userInfo, @RequestBody BookApp bookApp)
			throws BizException, PermissionException, JsonParseException;

	/**
	 * 删除书籍应用关联关系
	 *
	 * @param token
	 * @param bookAppId
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "删除书籍应用关联关系", httpMethod = "GET")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
			@ApiImplicitParam(name = "bookAppId", value = "图书应用标识", dataType = "long", paramType = "query") })
	@RequestMapping(value = "delete", method = RequestMethod.GET)
	public ResponseDto<?> delete(@RequestHeader("token") String token,
			@RequestParam(value = "bookAppId", required = false) Long bookAppId)
			throws BizException, PermissionException, JsonParseException;

	/**
	 * 微信端删除书籍应用关联关系
	 *
	 * @param userInfo
	 * @param bookAppId
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "微信端删除书籍应用关联关系", httpMethod = "GET")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "string", paramType = "header"),
			@ApiImplicitParam(name = "bookAppId", value = "图书应用标识", dataType = "long", paramType = "query") })
	@RequestMapping(value = "delete4Wechat", method = RequestMethod.GET)
	public ResponseDto<?> delete4Wechat(@CookieValue("userInfo") String userInfo,
			@RequestParam(value = "bookAppId", required = false) Long bookAppId)
			throws BizException, PermissionException, JsonParseException;

	/**
	 * 获取书籍关联的应用
	 *
	 * @param userInfo
	 * @param bookId
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */

	@ApiOperation(value = "获取书籍关联的应用", httpMethod = "GET")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "string", paramType = "header"),
			@ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
			@ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query") })
	@RequestMapping(value = "listById", method = RequestMethod.GET)
	public ResponseDto<List<BookAppDto>> getListById(@CookieValue("userInfo") String userInfo,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "adviserId", required = false) Long adviserId)
			throws BizException, PermissionException, JsonParseException;

	/**
	 * 获取书籍关联的应用(pc - 编辑)
	 *
	 * @param token
	 * @param bookId
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "获取书籍关联的应用(pc - 编辑)", httpMethod = "GET")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
			@ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
			@ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query") })
	@RequestMapping(value = "listById4Adviser", method = RequestMethod.GET)
	public ResponseDto<List<BookAppDto>> getListById4Adviser(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "channelId", required = false) Long channelId)
			throws BizException, PermissionException, JsonParseException;

	/**
	 * 获取图书关联应用个数
	 *
	 * @param token
	 * @param bookId
	 * @param channelId
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "获取图书关联应用个数", httpMethod = "GET")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
			@ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
			@ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query") })
	@RequestMapping(value = "getAppCount", method = RequestMethod.GET)
	ResponseDto<CountDto> getAppCount(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "channelId", required = false) Long channelId)
			throws BizException, PermissionException, JsonParseException;

	/**
	 * 获取书籍关联的应用-出版端
	 *
	 * @param token
	 * @param bookId
	 * @param channelId
	 * @param adviserId
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "获取书籍关联的应用-出版端", httpMethod = "GET")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
			@ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
			@ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
			@ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query") })
	@RequestMapping(value = "listById4Agent", method = RequestMethod.GET)
	ResponseDto<List<BookAppDto>> getListById4Agent(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "channelId", required = false) Long channelId,
			@RequestParam(value = "adviserId", required = false) Long adviserId)
			throws BizException, PermissionException, JsonParseException;
}
