/**
 *
 */
package com.pcloud.book.book.facade;

import com.pcloud.book.base.dto.CountDto;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.book.dto.BookResourceDto;
import com.pcloud.book.book.entity.BookResource;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.codehaus.jackson.JsonParseException;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @描述：
 * @作者：lili
 * @创建时间：2017年3月17日,下午4:06:04 @版本：1.0
 */
@Api(description = "书籍资源关系管理外部服务")
public interface BookResourceFacade {

    /**
     * 添加书籍和资源关联关系
     *
     * @param token
     * @param bookResource 书籍资源
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "添加书籍和资源关联关系", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookResource", value = "书籍资源关系实体", dataType = "BookResource", paramType = "body")})
    @RequestMapping(value = "create", method = RequestMethod.POST)
    public ResponseDto<BookResourceDto> create(@RequestHeader("token") String token,
                                               @RequestBody BookResource bookResource) throws BizException, PermissionException, JsonParseException;

    /**
     * 微信端添加书籍和资源关联关系
     *
     * @param token
     * @param bookResource 书籍资源
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "微信端添加书籍和资源关联关系", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookResource", value = "书籍资源关系实体", dataType = "BookResource", paramType = "body")})
    @RequestMapping(value = "create4Wechat", method = RequestMethod.POST)
    public ResponseDto<BookResourceDto> create4Wechat(@CookieValue("userInfo") String userInfo,
                                                      @RequestBody BookResource bookResource) throws BizException, PermissionException, JsonParseException;

    /**
     * 删除书籍资源关联关系
     *
     * @param token
     * @param bookResourceId 书籍资源标识
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "删除书籍资源关联关系", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookResourceId", value = "图书资源标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "delete", method = RequestMethod.GET)
    public ResponseDto<?> delete(@RequestHeader("token") String token,
                                 @RequestParam(value = "bookResourceId", required = false) Long bookResourceId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 微信端删除书籍资源关联关系
     *
     * @param token
     * @param bookResourceId 书籍资源标识
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "微信端删除书籍资源关联关系", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookResourceId", value = "图书资源标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "delete4Wechat", method = RequestMethod.GET)
    public ResponseDto<?> delete4Wechat(@CookieValue("userInfo") String userInfo,
                                        @RequestParam(value = "bookResourceId", required = false) Long bookResourceId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取书籍关联的资源（包含作品）
     *
     * @param token
     * @param bookId    书籍标识
     * @param channelId 渠道标识
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "获取书籍关联的资源（包含作品）", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "listById", method = RequestMethod.GET)
    public ResponseDto<BookDto> getListById(@CookieValue("userInfo") String userInfo,
                                            @RequestParam(value = "bookId", required = false) Long bookId,
                                            @RequestParam(value = "adviserId", required = false) Long adviserId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取关联资源个数
     *
     * @param token
     * @param bookId
     * @return
     */
    @ApiOperation(value = "获取关联资源个数", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getResourceCount", method = RequestMethod.GET)
    public ResponseDto<CountDto> getResourceCount(@RequestHeader("token") String token,
                                                  @RequestParam(value = "bookId", required = false) Long bookId,
                                                  @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取书籍关联的资源（代理）
     * @param token
     * @param bookId
     * @param channelId
     * @param adviserId
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "获取书籍关联的资源（代理）", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "listById4Agent", method = RequestMethod.GET)
    public ResponseDto<List<BookResourceDto>> listById4Agent(String token, Long bookId, Long channelId, Long adviserId)
            throws BizException, PermissionException, JsonParseException;
}
