package com.pcloud.book.consumer.common;

import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.commoncenter.whitelist.entity.AdviserWhitelist;
import com.pcloud.commoncenter.whitelist.service.AdviserWhitelistService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class CommonConsr {

    private static final Logger LOGGER = LoggerFactory.getLogger(CommonConsr.class);

    @Autowired
    private AdviserWhitelistService adviserWhitelistService;


    /**
     * 是否开启了新版数据统计
     */
    public AdviserWhitelist getByAdviserId(Long adviserId) {
        try {
            ResponseEntity<ResponseDto<AdviserWhitelist>> response = adviserWhitelistService.getByAdviserId(adviserId);
            AdviserWhitelist adviserWhitelist = ResponseHandleUtil.parseResponse(response, AdviserWhitelist.class);
            return adviserWhitelist;
        } catch (Exception e) {
            LOGGER.error("Excel导出失败[exportService.exportExcel]>>>>>" + e.getMessage(), e);
        }
        return new AdviserWhitelist();
    }
}
