package com.pcloud.book.copyright.dao;

import com.pcloud.book.copyright.entity.BookExportRecord;
import com.pcloud.common.core.dao.BaseDao;

/**
 * @author lily
 * @date 2018/12/4 19:20
 */
public interface BookExportRecordDao extends BaseDao<BookExportRecord> {

    /**
     * 更新导出记录
     */
    void updateRecordStatus(BookExportRecord bookExportRecord);

    /**
     * 获取是否有正在导出的数据
     */
    Boolean isHaveExport(Long bookId, Long channelId, Long adviserId);

    /**
     * 更新导出记录
     */
    void updateRecord(BookExportRecord bookExportRecord);

    /**
     * 处理导出
     */
    void handleExportFail();

    /**
     * 获取最后一次导出的地址
     */
    String getExportUrl(Long bookId, Long channelId, Long adviserId,Long sceneId);
}
