package com.pcloud.book.custom.entity;

import java.util.Date;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 邮件提醒(CustomPlanEmail)实体类
 *
 * @author zyq
 * @since 2020-03-06 13:59:25
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CustomPlanEmail extends BaseEntity {

    private static final long serialVersionUID = -65823605833429988L;
    
    @ApiModelProperty("主键")
    private Long id;
    
    @ApiModelProperty("方案id")
    private Integer customPlanId;
    
    @ApiModelProperty("邮件")
    private String emails;
    
    @ApiModelProperty("邮件补充内容")
    private String description;
    
    @ApiModelProperty("小睿wxId")
    private String robotId;
    
    @ApiModelProperty("分类名称")
    private String pcloudRobotClassifyName;
    
    @ApiModelProperty("用户微信id")
    private String userWxId;
    
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    
}