package com.pcloud.book.group.dao;

import com.pcloud.book.group.dto.BookAppletSceneDTO;
import com.pcloud.book.group.entity.BookAppletScene;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * 社群书小程序码
 */
public interface BookAppletSceneDao extends BaseDao<BookAppletScene> {

    /**
     * 根据小程序id获取关联信息
     * @param appletId
     * @return
     */
    public BookAppletScene getByAppletId(String appletId);

    /**
     * 根据bookGroupId获取
     * @param bookGroupId
     * @return
     */
    public BookAppletScene getByBookGroupId(Long bookGroupId);

    /**
     * 更新分类
     * @param raysClassifyId
     * @param bookGroupId
     */
    public void updateRaysClassifyIdByBookGroupId(Long raysClassifyId,Long bookGroupId);

    /**
     * 删除
     * @param bookGroupId
     */
    public void deleteByBookGroupId(Long bookGroupId);

    BookAppletScene getBySceneId(Long sceneId);

    /**
     * 通过自有码sceneId查询小程序相关信息
     * @param sceneIds
     * @return
     */
    BookAppletSceneDTO getBySceneIds(List<Long> sceneIds);

    /**
     * 根据bookid获取小程序码
     * @param bookId
     * @param channelId
     * @param adviserId
     * @return
     */
    BookAppletSceneDTO getBookAppletByBookId(Long bookId, Long channelId, Long adviserId);

    String getAppletIdByBookGroupId(Long bookGroupId);

    String getAppletIdBySceneId(Long sceneId);
}
