package com.pcloud.book.group.dao;

import com.pcloud.book.group.dto.ResourceOnBookDTO;
import com.pcloud.book.group.dto.BookGroupServeCountDTO;
import com.pcloud.book.group.dto.BookServeDTO;
import com.pcloud.book.group.dto.ResourcePageUrlDTO;
import com.pcloud.book.group.entity.BookGroupServe;
import com.pcloud.book.group.entity.ResourcePageItem;
import com.pcloud.book.group.vo.ResourcePageItemVO;
import com.pcloud.common.core.dao.BaseDao;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

/**
 * 自有码H5页面栏目资源详情(ResourcePageItem)表数据库访问层
 *
 * @author makejava
 * @since 2021-03-26 15:26:22
 */
public interface ResourcePageItemDao extends BaseDao<ResourcePageItem>{

    /**
     * 删除栏目下资源
     * @author：zhuyajie
     * @date：2021/3/26 15:39
     *  * @param null
     */
    void deleteByPageColumnId(Long resourcePageColumnId);
    /**
     * 查栏目资源
     * @author：zhuyajie
     * @date：2021/3/29 13:59
     *  * @param null
     */
    List<ResourcePageItemVO> getResourcePageItemByColumnId(Long resourcePageColumnId);

    /**
     * 查资源配置资源列表
     * @author：zhuyajie
     * @date：2021/3/29 16:38
     *  * @param null
     */
    List<ResourcePageItemVO> getResourcePageItemByPageId(Long resourcePageId, Boolean isShow);

    /**
     * 查资源数
     * @author：zhuyajie
     * @date：2021/4/16 13:42
     *  * @param null
     */
    Integer getResourceCounts(Long resourcePageId);

    /**
     * 查应用作品资源
     * @author：zhuyajie
     * @date：2021/4/17 13:14
     *  * @param null
     */
    List<BookGroupServe> getServeListByBookGroupId(Long bookGroupId);

    void deleteByPageId(Long resourcePageId);

    List<BookGroupServe> getServeListByBookGroupIds(List<Long> bookGroupIds);

    /**
     * 查应用作品资源
     * @author：zhuyajie
     * @date：2021/4/21 10:11
     *  * @param null
     */
    List<BookGroupServe> getServeListBySceneIds(List<Long> sceneIds);

    /**
     * 检查是否只有一个应用/作品
     * @author：zhuyajie
     * @date：2021/4/21 15:29
     *  * @param null
     */
    ResourcePageItemVO checkOneServeItemByPageId(Long resourcePageId);

    void deleteByServeId(Long resourceId);

    /**
     * 查配置的应用作品
     * @author：zhuyajie
     * @date：2021/5/11 19:53
     *  * @param null
     */
    List<BookServeDTO> getAppServeByPage(Long resourcePageId);

    List<ResourcePageUrlDTO> getServeUrl4Update(List<Long> sceneIdList);

    void batchUpdateServeUrlById(List<ResourcePageUrlDTO> list);

    /**
     *  算码下面的资源
     * @param ruiList
     * @return
     */
    Map<Long, BookGroupServeCountDTO> mapQrServeCount(List<Long> ruiList);

    /**
     * 过滤有资源的rays码
     * @param sceneIds
     * @return
     */
    List<Long> getHasResourceCode4Erp(List<Long> sceneIds);

    /**
     * 查码下配置的应用id
     * @author：zhuyajie
     * @date：2021/6/10 11:13
     *  * @param null
     */
    List<Long> getAppIdsByPageId(Long resourcePageId);

    /**
     * 书下所有资源
     * @author：zhuyajie
     * @date：2021/7/27 14:07
     *  * @param null
     */
    List<BookServeDTO> getBookAllServeIds(Long adviserId, Long bookId, Long channelId);

    /**
     * 配置的弹窗类型公众号
     * @author：zhuyajie
     * @date：2021/8/23 17:52
     *  * @param null
     */
    ResourcePageItemVO getPopupQrcodeItem(Long resourcePageId);

    /**
     * 栏目配置的RAYS工具类型
     * @author：zhuyajie
     * @date：2021/8/30 16:34
     *  * @param null
     */
    List<String> getConfiguredRaysAppTypeCode(Long resourcePageColumnId);

    /**
     * 需要同步到channel的资源列表
     * @author：zhuyajie
     * @date：2021/9/28 10:19
     *  * @param null
     */
    List<ResourcePageItemVO> getServeListBySceneId4QrUpdate(Long sceneId);

    /**
     * @Description  资源上书情况
     * @Author zhuyajie
     * @Date 19:01 2021/12/14
     **/
    List<ResourceOnBookDTO> listResourceOnBook(Map<String,Object> paramMap);

    List<BookGroupServe> getResourcePageList4Erp(List<Long> sceneIds);
}
