package com.pcloud.book.group.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * CRM 企业微信活码信息
 */
@Data
public class CrmContactQrcodeVO implements Serializable {

    private static final long serialVersionUID = 7917025011133902375L;

    /**
     * 活码ID
     */
    private Long contactQrcodeId;

    /**
     * 活码地址
     */
    private String qrcodeUrl;

    /**
     * 活码OSS地址
     */
    private String qrcodeUrlOss;

    /**
     * 活码解析地址
     */
    private String parseLink;

    /**
     * 活码名称
     */
    private String contactQrcodeName;

    /**
     * 扫码添加次数
     */
    private Integer addCount;

    /**
     * 扫码添加次数
     */
    private Integer addUser;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * 跳过验证标志
     */
    private Integer skipVerifyFlag;

    /**
     * 跳过验证时间标志
     */
    private Integer skipVerifyTimeFlag;

    /**
     * 水印标志
     */
    private Integer watermarkFlag;

    /**
     * 水印
     */
    private String watermark;


}
