package com.pcloud.book.pcloudkeyword.dao.impl;

import com.pcloud.book.pcloudkeyword.dao.PcloudKeywordClassifyDao;
import com.pcloud.book.pcloudkeyword.dto.PcloudKeywordClassifyDTO;
import com.pcloud.book.pcloudkeyword.entity.PcloudKeywordClassify;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *平台端个人号关键词分类
 */
@Component("pcloudKeywordClassifyDao")
public class PcloudKeywordClassifyDaoImpl extends BaseDaoImpl<PcloudKeywordClassify> implements PcloudKeywordClassifyDao {
    @Override
    public void setDeleteById(Long id) {
        getSessionTemplate().update(getStatement("setDeleteById"), id);
    }

    @Override
    public void updateOpenById(Long id, Boolean open) {
        Map<String,Object> map = new HashMap<>();
        map.put("id",id);
        map.put("open",open);
        getSessionTemplate().update(getStatement("updateOpenById"),map);
    }

    @Override
    public List<PcloudKeywordClassifyDTO> list(String classify) {
        Map<String,Object> map = new HashMap<>();
        map.put("classify", classify);
        return getSessionTemplate().selectList(getStatement("list"), map);
    }
}
